<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
function my_theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css');

}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles',10);        
// END ENQUEUE PARENT ACTION
///////////////////////////////////////////////////////////////////
//redirect to login page if user not logged in
function admin_redirect() {
   if ( !is_user_logged_in()) {
       wp_redirect( home_url('/wp-admin') );
       exit;
   }
}
add_action('get_header', 'admin_redirect');
///////////////////////////////////////////////////////////////////
//ADD PREFIX TO WOOCOMMERCE ORDER NUMBER

function prefix_woocommerce_order_number( $oldnumber, $order ) {
	return 'OL-' . $order->id;
}
add_filter( 'woocommerce_order_number', 'prefix_woocommerce_order_number', 1, 2 );

//////////////////////////////////////////////////
//OVERIDE WOOCOMMERCE LOST PASSWORD REDIRECT

function reset_pass_url() {
    $siteURL = get_option('siteurl');
    return "{$siteURL}/wp-login.php?action=lostpassword";
}
add_filter( 'lostpassword_url',  'reset_pass_url', 11, 0 );

///////////////////////////////////////////////
//DISABLE UPDATE NOTIFICATIONS TO NON ADMIN
function remove_dashboard_error_notifications() {
global $user_level;
	if ($user_level != '10' ) {
  echo '<style>
   div.updated.fade,div.update-nag,div.error,.settings-error{
      display: none;
      
    }  
  </style>';
  }
}
add_action('admin_head', 'remove_dashboard_error_notifications');

///////////////////////////////////////////////
//DEFAULT NO IMAGE AVAILABLE FOR WOO PRODUCTS

add_action( 'init', 'custom_fix_thumbnail' );
 
function custom_fix_thumbnail() {
  add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
   
	function custom_woocommerce_placeholder_img_src( $src ) {
	$upload_dir = wp_upload_dir();
	$uploads = untrailingslashit( $upload_dir['baseurl'] );
	$src = $uploads . '/wpallimport/files/no_image_available.jpg';
	 
	return $src;
	}
}

///////////////////////////////////////////////
//DO NOT ALLOW PO BOX

add_action('woocommerce_after_checkout_validation', 'deny_pobox_postcode');
function deny_pobox_postcode( $posted ) {
 global $woocommerce;
  $address  = ( isset( $posted['shipping_address_1'] ) ) ?     
 $posted['shipping_address_1'] : $posted['billing_address_1'];
 $postcode = ( isset( $posted['shipping_postcode'] ) ) ?  
 $posted['shipping_postcode'] : $posted['billing_postcode'];
 $replace  = array(" ", ".", ",");
 $address  = strtolower( str_replace( $replace, '', $address ) );
 $postcode = strtolower( str_replace( $replace, '', $postcode ) );
 if ( strstr( $address, 'pobox' ) || strstr( $postcode, 'pobox' ) ) {
   $notice = sprintf( __( '%1$sSorry, we are unable to ship to P.O. Boxes.' , 'error' ) , '<strong>' , '</strong>' );
        if ( version_compare( WC_VERSION, '2.3', '<' ) ) {
            $woocommerce->add_error( $notice );
        } else {
            wc_add_notice( $notice, 'error' );
        }
  }
}


///////////////////////////////////////////////
//ADD PRODUCT DESCRIPTION TO CART PAGE
add_filter( 'woocommerce_get_item_data', 'wc_checkout_description_so_15127954', 10, 2 );

function wc_checkout_description_so_15127954( $other_data, $cart_item )
{
    $post_data = get_post( $cart_item['product_id'] );
    $other_data[] = array( 'name' =>  $post_data->post_content );
    return $other_data;
}

///////////////////////////////////////////////
//Dont Save Shipping address

add_filter( 'woocommerce_checkout_get_value', 'reigel_empty_checkout_shipping_fields', 10, 2 );
function reigel_empty_checkout_shipping_fields( $value, $input ) {
//    /*
//    Method 1
//    you can check the field if it has 'shipping_' on it...
    if ( strpos( $input, 'shipping_' ) !== FALSE ) {
        $value = '';
  }

//    Method 2
//    put all the fields you want in an array...
//    */
    $shipping_fields = array(
        'shipping_first_name',
        'shipping_last_name',
        'shipping_company',
        'shipping_country',
        'shipping_address_1',
        'shipping_address_2',
        'shipping_city',
        'shipping_state',
        'shipping_country',
        'shipping_postcode',
	'shipping_phone',
	'shipping_email'
    );

    if ( in_array( $input, $shipping_fields ) ) {
        $value = '';
    }
//
   return $value;
}



///////////////////////////////////////////////
//Remove shipping from cart page
function disable_shipping_calc_on_cart( $show_shipping ) {
    if( is_cart() ) {
        return false;
    }
    return $show_shipping;
}
add_filter( 'woocommerce_cart_ready_to_calc_shipping', 'disable_shipping_calc_on_cart', 99 );


///////////////////////////////////////////////////////////////////
//ADD QUANTITY FIELD TO WOOCOMMERCE ARCHIVE/SHOP PAGE

add_filter( 'woocommerce_loop_add_to_cart_link', 'quantity_inputs_for_woocommerce_loop_add_to_cart_link', 10, 2 );
function quantity_inputs_for_woocommerce_loop_add_to_cart_link( $html, $product ) {
	if ( $product && $product->is_type( 'simple' ) && $product->is_purchasable() && $product->is_in_stock() && ! $product->is_sold_individually() ) {
		$html = '<form action="' . esc_url( $product->add_to_cart_url() ) . '" class="cart" method="post" enctype="multipart/form-data">';
		$html .= woocommerce_quantity_input( array(), $product, false );
		$html .= '<button type="submit" class="button alt">' . esc_html( $product->add_to_cart_text() ) . '</button>';
		$html .= '</form>';
	}
	return $html;
}



///////////////////////////////////////////////////////////////////
//ADD HANDLING FEE OF PRODUCTS WITH HANDLING TAXONOMY


function df_add_ticket_surcharge( $cart_object ) {

    global $woocommerce;
    $specialfeecat = 1533; // category id for the special fee
    $spfee = 0.00; // initialize special fee
    $spfeeperprod = 0.02; //special fee per product

    foreach ( $cart_object->cart_contents as $key => $value ) {

        $proid = $value['product_id']; //get the product id from cart
        $quantiy = $value['quantity']; //get quantity from cart
        $itmprice = $value['data']->price; //get product price

        $terms = get_the_terms( $proid, 'product_tag' ); //get taxonamy of the prducts
        if ( $terms && ! is_wp_error( $terms ) ) :
            foreach ( $terms as $term ) {
                $tagid = $term->term_id;
                if($specialfeecat == $tagid ) {
                    $spfee = $spfee + $itmprice * $quantiy * $spfeeperprod;
                }
            }
        endif;  
    }

    if($spfee > 0 ) {

       $woocommerce->cart->add_fee( 'Handling ', $spfee, true, 'standard' );
		
    }

}

add_action( 'woocommerce_cart_calculate_fees', 'df_add_ticket_surcharge' );

////////////////////////////////////////////////////////////////////////////
//UNCHECK ALL SHIPPING METHODS AND FORCE CUSTOMER TO MAKE SELECTION
function reset_default_shipping_method( $method, $available_methods ) {
    $default_method = 'FEDEX_GROUND'; 
    if( array_key_exists($method, $available_methods ) )		
    	return $default_method;
    else
    	return $method;
}
add_filter('woocommerce_shipping_chosen_method', 'reset_default_shipping_method', 10, 2);

////////////////////////////////////////////////////////////////////////////
//IF FLAG SIGN IS IN CART, ADD HARDWARE KIT.
//function bbloomer_add_gift_if_sku_added_cart( $passed, $product_id, $quantity ) {
//global $woocommerce;
 
/* enter array of SKUs that give gift */
//$flagsigns = array(589548,	589549,	589550,	445854,	445942,	446776,	446996,	447009,	448627,	449066,	450996,	451512,	451513,	451515,	452153,	452147,	594057,	594058,	594059,	594060,	594061,	594062,	594063,	594065,	589515,	589516,	589517,	452151,	452152,	452155,	452156,	452157,	452158,	452159,	452161,	452163,	452164,	452166,	452167,	452168,	594066,	594067,	594068,	594069,	594070,	594071,	594073,	594074);
 
/* enter SKU of product gift */
//$kitSku = '594903';
 

 
//$product = wc_get_product( $product_id );
 
//if ( $product->get_sku() && in_array( $product->get_sku(), $flagsigns ) ) {
    

  	//WC()->cart->add_to_cart( wc_get_product_id_by_sku($kitSku) );

	
	
    //wc_add_notice( __( 'Flag Sign Hardware Kit', 'woocommerce' ), 'success' );
    
//}
//return $passed;
//}
 
//add_filter( 'woocommerce_add_to_cart_validation', 'bbloomer_add_gift_if_sku_added_cart', 10, 3 );

//**
 //* Add a 10% surcharge to your cart / checkout 
 //* change the $percentage to set the surcharge to a value to suit
 //*/
//add_action( 'woocommerce_cart_calculate_fees','woocommerce_custom_surcharge' );
//function woocommerce_custom_surcharge() {
  //global $woocommerce;

  //if ( is_admin() && ! defined( 'DOING_AJAX' ) )
    //return;

  //$percentage = 0.16;
  //$surcharge = ( $woocommerce->cart->cart_contents_total ) * $percentage;  
  //$woocommerce->cart->add_fee( 'Surcharge', $surcharge, true, '' );

//}

//
/*
Plugin Name: PHP Compatibility Custom Timeout
*/

function custom_timeout( $timeout ) {
	return 0;
}

add_filter( 'wpephpcompat_scan_timeout', 'custom_timeout', 10 );
