<?php
/**
 * This is the front page code
 * Template Name: Register/Login
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> style="height:100%;background:#f5f5f5;">
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="page" class="hfeed site">

<div class="site-content"> <?php

global $post;
$single_page_layout = esc_attr( get_post_meta($post->ID, 'accesspress_store_sidebar_layout', true) );
if (empty($single_page_layout)) {
    $single_page_layout = esc_attr( get_theme_mod('single_page_layout','right-sidebar') );
}
if (is_page('cart') || is_page('checkout')) {
    $single_page_layout = "no-sidebar";
}
$breadcrumb = intval( get_theme_mod('breadcrumb_options_page','1') );
$archive_bread = esc_url( get_theme_mod('breadcrumb_page_image') );
if($archive_bread){
    //$bread_archive = $archive_bread;
}else{
  //$bread_archive = esc_url ( get_template_directory_uri().'/images/about-us-bg.jpg' );
}
if($breadcrumb == '1') :
?>
<div class="page_header_wrap clearfix" style="background:#f5f5f5;padding:50px 0px 50px;">
    <div class="ak-container">
        <header class="entry-header">
           
        </header><!-- .entry-header -->
       
    </div>
</div>
<?php endif; ?>
<div class="inner" style="height:100%;">
    <main id="main" class="site-main clearfix <?php echo $single_page_layout; ?>">
        <?php if ($single_page_layout == 'both-sidebar'): ?>
            <div id="primary-wrap" class="clearfix">
        <?php endif; ?>

            <div id="primary" class="content-area">
          <?php while ( have_posts() ) : the_post(); ?>

                  
                  
                  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <div class="entry-content">
                        <?php if (has_post_thumbnail()): ?>
                            <div class="post-thumbnail">
                                <?php the_post_thumbnail('accesspress-blog-big-thumbnail'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="content-inner clearfix style="padding:50px 10px;"">
                           
                            <div class="content-page">
                                <?php the_content(); ?>
                            </div>
                            <?php
                            wp_link_pages(array(
                                'before' => '<div class="page-links">' . __('Pages:', 'accesspress-store'),
                                'after' => '</div>',
                            ));
                            ?>
                        </div>
                    </div><!-- .entry-content -->
                
                </article><!-- #post-## -->
                  
                    <?php
                    // If comments are open or we have at least one comment, load up the comment template
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;
                    ?>
                <?php endwhile; // end of the loop.  ?>
            </div><!-- #primary -->

     
    </main>
</div>
</div><!-- #content -->

<!--begin footer -->
<footer id="colophon" class="site-footer login-footer" style="background:#f5f5f5;">
    
</footer><!-- #colophon -->
</div><!-- #page -->
<div id="ak-top"><i class="fa fa-reply"></i></div>
<?php wp_footer(); ?>
</body>
</html>
