<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Install routine class
 *
 * @since  2.3.5
 * @author VanboDevelops
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class WC_Paytrace_Updates {
	
	public $gateway_id;
	public $version;
	
	/**
	 * @param $gateway_id
	 */
	public function __construct( $gateway_id ) {
		$this->gateway_id = $gateway_id;
		$this->version    = get_option( 'wc_version_' . $this->gateway_id, '1.4.9' );
	}
	
	/**
	 * Loads the hooks
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'check_version_and_update' ), 0 );
	}
	
	/**
	 * Checks the version and runs the update procedure
	 */
	public function check_version_and_update() {
		if ( ! defined( 'IFRAME_REQUEST' ) && $this->version !== \WC_Paytrace::VERSION ) {
			$this->update();
		}
	}
	
	/**
	 * Performs needed updates for the plugin for moving through version
	 */
	public function update() {
		if ( version_compare( $this->version, '2.0.0', '<' ) && version_compare( \WC_Paytrace::VERSION, '2.0.0', '>=' ) ) {
			$settings = get_option( 'woocommerce_' . $this->gateway_id . '_settings' );
			
			if ( ! isset( $settings['integration'] ) ) {
				$settings['integration'] = 'json';
				if ( isset( $settings['password'] ) && '' != $settings['password'] ) {
					$settings['integration'] = 'post';
				}
				
				update_option( 'woocommerce_' . $this->gateway_id . '_settings', $settings );
			}
		}
		
		// 2.4.0 - Update the "separated_forms" setting
		if ( version_compare( $this->version, '2.4.0', '<' ) && version_compare( \WC_Paytrace::VERSION, '2.4.0', '>=' ) ) {
			$settings = get_option( 'woocommerce_' . $this->gateway_id . '_settings' );
			
			$separation_forms = WC_Paytrace::get_field( 'separated_forms', $settings, null );
			$password         = WC_Paytrace::get_field( 'password', $settings, '' );
			
			// If the plugin is in use, we want to keep the forms as they were
			if ( null == $separation_forms && '' != $password ) {
				$settings['separated_forms'] = 'together';
				
				update_option( 'woocommerce_' . $this->gateway_id . '_settings', $settings );
			}
		}
		
		// 2.6.0 - Move the public key to a textarea setting
		if ( version_compare( $this->version, '2.6.0', '<' ) && version_compare( \WC_Paytrace::VERSION, '2.6.0', '>=' ) ) {
			$this->update_public_key_contents();
		}
		
		if ( version_compare( $this->version, '2.7.0', '<' ) && version_compare( \WC_Paytrace::VERSION, '2.7.0', '>=' ) ) {
			$this->update_security_setting();
		}
		
		// Save the current version
		update_option( 'wc_version_' . $this->gateway_id, \WC_Paytrace::VERSION );
	}
	
	/**
	 * Moves the public key location setting to a plain text public key
	 *
	 * @since 2.6.0
	 */
	public function update_public_key_contents() {
		$settings = get_option( 'woocommerce_' . $this->gateway_id . '_settings' );
		
		if ( 'json' !== WC_Paytrace::get_field( 'integration', $settings, '' ) ) {
			return;
		}
		
		$key_location = WC_Paytrace::get_field( 'json_public_key_location', $settings, null );
		$key_contents = '';
		if ( '' != $key_location && false !== strpos( WC_Paytrace::get_field( 0, get_headers( $key_location ), '' ), "200 OK" ) ) {
			$key_contents = file_get_contents( $key_location );
		}
		
		$settings['json_public_key'] = $key_contents;
		
		update_option( 'woocommerce_' . $this->gateway_id . '_settings', $settings );
	}
	
	public function update_security_setting() {
		$settings = get_option( 'woocommerce_' . $this->gateway_id . '_settings' );
		
		if ( 'json' !== WC_Paytrace::get_field( 'integration', $settings, '' ) ) {
			return;
		}
		
		$key_location = WC_Paytrace::get_field( 'json_public_key_location', $settings, null );
		$key_contents = WC_Paytrace::get_field( 'json_public_key', $settings, null );
		
		// If both are empty, then we can keep the security type as protect.js
		if ( '' == $key_location && '' == $key_contents ) {
			return;
		}
		
		$use_encryption = WC_Paytrace::get_field( 'json_use_encryption_js', $settings, 'no' );
		if ( 'yes' !== $use_encryption ) {
			return;
		}
		
		$settings['json_security_type'] = 'encryption';
		
		update_option( 'woocommerce_' . $this->gateway_id . '_settings', $settings );
	}
}