<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ajax class to handle ajax requests
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class WC_Paytrace_Ajax {
	
	public function hooks() {
		add_action( 'wp_ajax_wc_paytrace_capture_payment', array( $this, 'capture_payment' ) );
	}
	
	/**
	 * Handle a refund via the edit order screen.
	 *
	 * @since 2.0
	 */
	public function capture_payment() {
		ob_start();
		
		check_ajax_referer( 'capture-payment', 'security' );
		
		if ( ! current_user_can( 'edit_shop_orders' ) ) {
			wp_die( - 1 );
		}
		
		$order_id       = absint( $_POST['order_id'] );
		$capture_amount = wc_format_decimal( sanitize_text_field( $_POST['capture_amount'] ), wc_get_price_decimals() );
		$response_data  = array();
		
		try {
			$order = wc_get_order( $order_id );
			
			// Init the gateways
			WC()->payment_gateways();
			
			if ( ! $capture_amount ) {
				throw new Exception( __( 'Invalid refund amount', WC_Paytrace::TEXT_DOMAIN ) );
			}
			
			// Run the capture payment action
			do_action( 'wc_paytrace_capture_payment_for_order', $order, $capture_amount );
			
			$response_data['status'] = 'captured';
			
			wp_send_json_success( $response_data );
		}
		catch ( Exception $e ) {
			wp_send_json_error( array( 'error' => $e->getMessage() ) );
		}
	}
}