<?php
/**
 * Plugin Name: AvaTax Integration for WooCommerce
 * Plugin URI: http://adipietro.com/products/taxnow-for-woocommerce/?ref=tnwoo&loc=ftr&ver=2.2
 * Description: The AvaTax Integration extends your WooCommerce store to enable sales tax, address validation, and global VAT from Avalara's AvaTax service.
 * Version: 2.3
 * Author: Adipietro Technology Services
 * Author URI: http://adipietro.com
 * Requires at least: 3.2
 * Tested up to: 4.0
 */

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}

/**
 * Check if WooCommerce is active before starting up TaxNOW
 */
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    
	/**
	 * WooCommerce is running, so...
	 *
	 * Load include files
	 */
	require('class-wc-avalara-base.php');		// base class
	require('class-wc-avalara.php');		// extended class
	require('class-wc-avalara-data.php');		// additional classes
	require('class-wc-avalara-lineitem.php');	// additional classes
	require('class-wc-avalara-tax-details.php');	// additional classes
	
	if ( ! class_exists( 'WC_Avatax' ) ) :
	
	class WC_Avatax {
	    
	   /**
	    * construct the plugin
	    */
	   public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'init' ) );
	   }
	   
	   /**
	    * initialize the plugin
	    */
	   public function init() {
	    
		// check if woocommerce is installed
		if ( class_exists( 'WC_Integration' ) ) {
		    // include the avatax integration
		    include_once 'class-wc-avatax-integration.php';
		    
	    	    // register the integration
		    add_filter( 'woocommerce_integrations', array( $this, 'add_integration' ) );
		}
	   }
	   
           /**
	    * Insert our settings into the WooCommerce integrations list
            */
           public function add_integration( $integrations ) {
               $integrations[] = 'WC_Avatax_Integration';
               return $integrations;
           }
	}
	
	$avatax_init = new WC_Avatax(); // removed __FILE__
	
	/**
	 * Kick off the main plugin class
	 */
	$avatax_main = new WC_Avalara();

	endif;
}

?>