<?php
/**
 * AvaTax integration settings page for WooCommerce
 *
 * @package  WC_Avatax_Integration
 * @category Integration
 * @author   TaxNOW
 */

if ( ! class_exists( 'WC_Avatax_Integration' ) ) :

class WC_Avatax_Integration extends WC_Integration {

	/**
	 * Init and hook in the integration.
	 */
	public function __construct() {
		global $woocommerce;

		$this->id                 = 'avatax';
		$this->method_title       = __( 'AvaTax', 'woocommerce-avatax' );
		$this->method_description = __( 'The AvaTax integration from Avalara provides instant, accurate sales tax and global VAT calculation during checkout, using pinpoint address accuracy and always the most up to date rate information.', 'woocommerce-avatax' );

		// Load the settings.
		$this->init_form_fields();
		$this->init_settings();

		// Define user set variables.
		$this->avalara_url             = $this->get_option( 'avalara_url' );
		$this->account                 = $this->get_option( 'account' );
		$this->license                 = $this->get_option( 'license' );
		$this->company_code            = $this->get_option( 'company_code' );
		$this->origin_street           = $this->get_option( 'origin_street' );
		$this->origin_city             = $this->get_option( 'origin_city' );
		$this->origin_state            = $this->get_option( 'origin_state' );
		$this->origin_zip              = $this->get_option( 'origin_zip' );
		$this->origin_country          = $this->get_option( 'origin_country' );
		$this->disable_tax_calc        = $this->get_option( 'disable_tax_calc' );
		$this->disable_addr_validation = $this->get_option( 'disable_addr_validation' );
		$this->default_tax_code        = $this->get_option( 'default_tax_code' );
		$this->default_freight_code    = $this->get_option( 'default_freight_code' );
		$this->cust_code_name          = $this->get_option( 'cust_code_name' );
		$this->tax_discount            = $this->get_option( 'tax_discount' );
		$this->discount_desc           = $this->get_option( 'discount_desc' );
		$this->business_vat_id         = $this->get_option( 'business_vat_id' );
		$this->tax_calc_filter_option  = $this->get_option( 'tax_calc_filter_option' );
		$this->tax_calc_filter_list    = $this->get_option( 'tax_calc_filter_list' );
		$this->addr_filter_option      = $this->get_option( 'addr_filter_option' );
		$this->addr_filter_list        = $this->get_option( 'addr_filter_list' );

		// New user variables added for v2.3
		$this->commit_action           = $this->get_option( 'commit_action' );
		$this->enable_exempt_id        = $this->get_option( 'enable_exempt_id' );

		// Actions.
		add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );

		// Filters. Not used. Retained for later.
//		add_filter( 'woocommerce_settings_api_sanitized_fields_' . $this->id, array( $this, 'sanitize_settings' ) );

	}


	/**
	 * Initialize integration settings form fields.
	 *
	 * @return void
	 */
	public function init_form_fields() {
		$this->form_fields = array(
			'avalara_section' => array(
				'title'             => __( 'AvaTax Service Connection Details', 'woocommerce-avatax' ),
				'type'              => 'title',
			),
			'avalara_url' => array(
				'title'             => __( 'Service Mode', 'woocommerce-avatax' ),
				'type'              => 'select',
				'description'       => __( 'Set the AvaTax service mode for live or test mode', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'https://avatax.avalara.net/',
				'options'           => array(
					"https://avatax.avalara.net/"		=> 'Production (Live)',
					"https://development.avalara.net/"	=> 'Development (Test)'
				),
			),
			'account' => array(
				'title'             => __( 'Account', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'AvaTax account number (from your Avalara welcome email) or login user ID (configured on your <a href="https://admin-avatax.avalara.net/login.aspx" target="_blank" style="target-new: tab;">AvaTax console</a>).', 'woocommerce-avatax' ),
				'desc_tip'          => false,
				'default'           => ''
			),
			'license' => array(
				'title'             => __( 'License', 'woocommerce-avatax' ),
				'type'              => 'password',
				'description'       => __( 'AvaTax license code (from your Avalara welcome email) or login password (configured on your <a href="https://admin-avatax.avalara.net/login.aspx" target="_blank" style="target-new: tab;">AvaTax console</a>).', 'woocommerce-avatax' ),
				'desc_tip'          => false,
				'default'           => ''
			),
			'company_code' => array(
				'title'             => __( 'Company code', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Company identifier (configured on your <a href="https://admin-avatax.avalara.net/login.aspx" target="_blank" style="target-new: tab;">AvaTax console</a>).', 'woocommerce-avatax' ),
				'desc_tip'          => false,
				'default'           => ''
			),
			'test_connection_button' => array(
				'title'             => __( 'Verify Account', 'woocommerce-avatax' ),
				'type'              => 'pingbutton',
				'custom_attributes' => array(
					'onclick'   => "",
				),
				'description'       => __( 'Test your connection to the AvaTax service and verify your account', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'address_section' => array(
				'title'             => __( 'Primary Ship From Address', 'woocommerce-avatax' ),
				'type'              => 'title'
			),
			'origin_street' => array(
				'title'             => __( 'Street Address', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Address of your main office or primary shipping warehouse', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => ''
			),
			'origin_city' => array(
				'title'             => __( 'City', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Address of your main office or primary shipping warehouse', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => ''
			),
			'origin_state' => array(
				'title'             => __( 'State / Province / Region', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Address of your main office or primary shipping warehouse', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => ''
			),
			'origin_zip' => array(
				'title'             => __( 'Postal Code', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Address of your main office or primary shipping warehouse', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => ''
			),
			'origin_country' => array(
				'title'             => __( 'Country', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Address of your main office or primary shipping warehouse', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'US'
			),
			'validate_addr_button' => array(
				'title'             => __( 'Validate Address', 'woocommerce-avatax' ),
				'type'              => 'addrbutton',
				'custom_attributes' => array(
					'onclick'   => "",
				),
				'description'       => __( 'Validate your business address and format to USPS standards', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'general_section' => array(
				'title'             => __( 'General Settings', 'woocommerce-avatax' ),
				'type'              => 'title',
			),
			'disable_tax_calc' => array(
				'title'             => __( 'Tax Calculation Service', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Disable', 'woocommerce-avatax' ),
				'default'           => 'no',
				'description'       => __( 'Prevent tax calculation requests from being sent to AvaTax', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'disable_addr_validation' => array(
				'title'             => __( 'Address Validation Service', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Disable', 'woocommerce-avatax' ),
				'default'           => 'no',
				'description'       => __( 'Prevent address validation requests from being sent to AvaTax', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'default_tax_code' => array(
				'title'             => __( 'Default tax code for all products', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'AvaTax system tax code to use for products that do not have a tax code specified', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'P0000000'
			),
			'default_freight_code' => array(
				'title'             => __( 'Default tax code for shipping cost', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'AvaTax system tax code to use for the cost of shipping and handling', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'FR'
			),
			'cust_code_name' => array(
				'title'             => __( 'Customer name instead of email', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Enable', 'woocommerce-avatax' ),
				'default'           => 'no',
				'description'       => __( 'Tell AvaTax to identify customers by their full name instead of their email address', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'tax_discount' => array(
				'title'             => __( 'Free tax discount (tax holiday)', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Enable', 'woocommerce-avatax' ),
				'default'           => 'no',
				'description'       => __( 'Add a discount to all orders equal to the sales tax amount', 'woocommerce-avatax' ),
				'desc_tip'          => true
			),
			'discount_desc' => array(
				'title'             => __( 'Tax discount description', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Short label to display on your checkout page to describe the tax discount', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'Free Tax Discount'
			),
			'business_vat_id' => array(
				'title'             => __( 'Business ID (for VAT users)', 'woocommerce-avatax' ),
				'type'              => 'text',
				'description'       => __( 'Government issued tax identification number for your business', 'woocommerce-avatax' ),
				'desc_tip'          => false,
				'default'           => ''
			),
			'commit_action' => array(
				'title'             => __( 'AvaTax Action for Completed Orders', 'woocommerce-avatax' ),
				'type'              => 'select',
				'description'       => __( 'Determines what type of transaction is sent to AvaTax when an order reaches Completed status.', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'c',
				'options'           => array(
					"c"		=> 'Committed SalesInvoice',
					"u"		=> 'Uncommitted SalesInvoice', 
					"n"		=> 'SalesOrder (Invisible)'
				),
			),
			'enable_exempt_id' => array(
				'title'             => __( 'Allow sales tax or VAT exemptions during checkout', 'woocommerce-avatax' ),
				'type'              => 'select',
				'description'       => __( 'Determines what type of exemptions (if any) can be claimed by customers on the checkout page.', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'n',
				'options'           => array(
					"n"		=> 'No Exemptions Allowed',
					"b"		=> 'Business VAT ID',
					"e"		=> 'Sales Tax Exemption ID'
				),
			),
			'filters_section' => array(
				'title'             => __( 'Service Filters', 'woocommerce-avatax' ),
				'type'              => 'title',
			),
			'tax_calc_filter_option' => array(
				'title'             => __( 'Limit tax calculation to Taxable Regions', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Enable', 'woocommerce-avatax' ),
				'description'       => __( 'Enable selection of which states/provinces will collect tax.', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'no'
			),
			'tax_calc_filter_list' => array(
				'title'             => __( 'Taxable regions', 'woocommerce-avatax' ),
				'type'              => 'multiselect',
				'description'       => __( 'Calculate tax only to selected regions. All other regions will receive zero tax.', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'options'           => array(
						'AL'=>"US - Alabama",
						'AK'=>"US - Alaska", 
						'AZ'=>"US - Arizona", 
						'AR'=>"US - Arkansas", 
						'CA'=>"US - California", 
						'CO'=>"US - Colorado", 
						'CT'=>"US - Connecticut", 
						'DE'=>"US - Delaware", 
						'DC'=>"US - District Of Columbia", 
						'FL'=>"US - Florida", 
						'GA'=>"US - Georgia", 
						'HI'=>"US - Hawaii", 
						'ID'=>"US - Idaho", 
						'IL'=>"US - Illinois", 
						'IN'=>"US - Indiana", 
						'IA'=>"US - Iowa", 
						'KS'=>"US - Kansas", 
						'KY'=>"US - Kentucky", 
						'LA'=>"US - Louisiana", 
						'ME'=>"US - Maine", 
						'MD'=>"US - Maryland", 
						'MA'=>"US - Massachusetts", 
						'MI'=>"US - Michigan", 
						'MN'=>"US - Minnesota", 
						'MS'=>"US - Mississippi", 
						'MO'=>"US - Missouri", 
						'MT'=>"US - Montana",
						'NE'=>"US - Nebraska",
						'NV'=>"US - Nevada",
						'NH'=>"US - New Hampshire",
						'NJ'=>"US - New Jersey",
						'NM'=>"US - New Mexico",
						'NY'=>"US - New York",
						'NC'=>"US - North Carolina",
						'ND'=>"US - North Dakota",
						'OH'=>"US - Ohio", 
						'OK'=>"US - Oklahoma", 
						'OR'=>"US - Oregon", 
						'PA'=>"US - Pennsylvania", 
						'RI'=>"US - Rhode Island", 
						'SC'=>"US - South Carolina", 
						'SD'=>"US - South Dakota",
						'TN'=>"US - Tennessee", 
						'TX'=>"US - Texas", 
						'UT'=>"US - Utah", 
						'VT'=>"US - Vermont", 
						'VA'=>"US - Virginia", 
						'WA'=>"US - Washington", 
						'WV'=>"US - West Virginia", 
						'WI'=>"US - Wisconsin", 
						'WY'=>"US - Wyoming",
						'AB'=>"Canada - Alberta",
						'BC'=>"Canada - British Columbia",
						'MB'=>"Canada - Manitoba",
						'NB'=>"Canada - New Brunswick",
						'NL'=>"Canada - Newfoundland and Labrador",
						'NT'=>"Canada - Northwest Territories",
						'NS'=>"Canada - Nova Scotia",
						'NU'=>"Canada - Nunavut",
						'ON'=>"Canada - Ontario",
						'PE'=>"Canada - Prince Edward Island",
						'QC'=>"Canada - Quebec",
						'SK'=>"Canada - Saskatchewan",
						'YT'=>"Canada - Yukon"
				)
			),
			'addr_filter_option' => array(
				'title'             => __( 'Limit address validation to selected countries', 'woocommerce-avatax' ),
				'type'              => 'checkbox',
				'label'             => __( 'Enable', 'woocommerce-avatax' ),
				'description'       => __( 'Enable selection of which countries to sanitize addresses', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'default'           => 'no'
			),
			'addr_filter_list' => array(
				'title'             => __( 'Countries for validation', 'woocommerce-avatax' ),
				'type'              => 'multiselect',
				'description'       => __( 'Address validation and correction is only available for US & Canada', 'woocommerce-avatax' ),
				'desc_tip'          => true,
				'options'           => array(
						'CA'=>"Canada",
						'US'=>"United States"
				)
			)
		);
	}


	/**
	 * Generate Ping Button HTML.
	 */
	public function generate_pingbutton_html( $key, $data ) {
		$field    = $this->plugin_id . $this->id . '_' . $key;
		$defaults = array(
			'class'             => 'button-secondary',
			'css'               => '',
			'custom_attributes' => array(),
			'desc_tip'          => false,
			'description'       => '',
			'title'             => '',
		);

		$data = wp_parse_args( $data, $defaults );

		ob_start();
		?>
		<script type="text/javascript" >
			jQuery(document).ready(function($) {
				jQuery('#woocommerce_avatax_test_connection_button_result').hide();
				
				jQuery('#woocommerce_avatax_test_connection_button').click(function(){    
					msg = 'Please wait...'
					jQuery('#woocommerce_avatax_test_connection_button_result').html(msg).show('300');
		
					var data = {
						action: 'taxnow_test_connection',
						avalara_url: jQuery('#woocommerce_avatax_avalara_url').val(),
						account: jQuery('#woocommerce_avatax_account').val(),
						license: jQuery('#woocommerce_avatax_license').val(),
						company_code: jQuery('#woocommerce_avatax_company_code').val()
					};
		
					jQuery.post(ajaxurl, data, function(response) {
						jQuery('#woocommerce_avatax_test_connection_button_result').html(response).show('300');
					});
				});
			});
		</script>

		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $field ); ?>"><?php //echo wp_kses_post( $data['title'] ); ?></label>
				<?php echo $this->get_tooltip_html( $data ); ?>
			</th>
			<td class="forminp">
				<fieldset>
					<legend class="screen-reader-text"><span><?php echo wp_kses_post( $data['title'] ); ?></span></legend>
					<button class="<?php echo esc_attr( $data['class'] ); ?>" type="button" name="<?php echo esc_attr( $field ); ?>" id="<?php echo esc_attr( $field ); ?>" style="<?php echo esc_attr( $data['css'] ); ?>"<?php echo $this->get_custom_attribute_html( $data ); ?>><?php echo wp_kses_post( $data['title'] ); ?></button>
					<?php echo $this->get_description_html( $data ); ?>
				</fieldset>
				<br/>
				<div id="<?php echo esc_attr( $field ) . '_result'; ?>" style="background-color:#ffffe0;border:1px #e6db55 solid; padding:4px; font-size:11px; display:none; width:340px;"></div>
			</td>
		</tr>
		<?php
		return ob_get_clean();
	}


	/**
	 * Generate Address Validation Button HTML.
	 */
	public function generate_addrbutton_html( $key, $data ) {
		$field    = $this->plugin_id . $this->id . '_' . $key;
		$defaults = array(
			'class'             => 'button-secondary',
			'css'               => '',
			'custom_attributes' => array(),
			'desc_tip'          => false,
			'description'       => '',
			'title'             => '',
		);

		$data = wp_parse_args( $data, $defaults );

		ob_start();
		?>

		<script type="text/javascript" >
			jQuery(document).ready(function($) {
				jQuery('#woocommerce_avatax_validate_addr_button_result').hide();
				
				jQuery('#woocommerce_avatax_validate_addr_button').click(function() {    
					taxnow_process_validation();
				});
			});

			var validated_origin_street  = '';
			var validated_origin_city    = '';
			var validated_origin_state   = '';
			var validated_origin_zip     = '';
			var validated_origin_country = '';

			function taxnow_process_validation() {
				var taxnow_origin_street  = jQuery('#woocommerce_avatax_origin_street').val();
				var taxnow_origin_city    = jQuery('#woocommerce_avatax_origin_city').val();
				var taxnow_origin_state   = jQuery('#woocommerce_avatax_origin_state').val();
				var taxnow_origin_zip     = jQuery('#woocommerce_avatax_origin_zip').val();
				var taxnow_origin_country = jQuery('#woocommerce_avatax_origin_country').val();

				// make sure we have data
				if ( taxnow_origin_street  =='' ||
				     taxnow_origin_city    =='' ||
				     taxnow_origin_state   =='' ||
				     taxnow_origin_zip     =='' ||
				     taxnow_origin_country =='') {

					jQuery('#woocommerce_avatax_validate_addr_button_result').html('Error! Please enter in all fields above').show('300');
					return false;
				}

				msg = 'Please wait...'
				jQuery('#woocommerce_avatax_validate_addr_button_result').html(msg).show('300');

				var data = {
					action:        'taxnow_validate_origin',
					origin_street:  taxnow_origin_street,
					origin_city:    taxnow_origin_city,
					origin_state:   taxnow_origin_state,
					origin_zip:     taxnow_origin_zip,
					origin_country: taxnow_origin_country
				};

				jQuery.ajax({
					url: ajaxurl,
					type: 'POST',
					dataType: 'json',
					data: data, 
					success: function(response) {

						if ( response['Status'] == '1') {
							var msg = response['Message'];
							validated_origin_street = response['Line1'];
							validated_origin_city = response['City'];
							validated_origin_state = response['Region'];
							validated_origin_zip = response['PostalCode'];
							validated_origin_country = response['Country'];
					
							if ( taxnow_origin_zip != validated_origin_zip) {
								jQuery('#woocommerce_avatax_origin_zip').val(validated_origin_zip);
								msg += '  Your postal code has been updated too.';
							}

							if ( taxnow_origin_street != validated_origin_street ||
							     taxnow_origin_city != validated_origin_city ||
							     taxnow_origin_state != validated_origin_state ||
							     taxnow_origin_country != validated_origin_country) {
						
								msg += '<br/><br/>Your address has been validated, but a better match was found:<br/>'+
									validated_origin_street+', '+validated_origin_city+', '+validated_origin_state+', '+validated_origin_zip+'<br/>'+
									'To use this recommended address, <a id="btn_taxnow_use_validated" style="cursor:pointer;" onclick="taxnow_use_validated();">click here</a>.';
							}

							jQuery('#woocommerce_avatax_validate_addr_button_result').html(msg).show('300');
						}

						else {	// status==0, means address not validated

							if ( response['Message'] )
								msg = response['Message'];

							else
								msg = 'unknown response';

							jQuery('#woocommerce_avatax_validate_addr_button_result').html(msg).show('300');
						}
					} ,

					error: function(jqXHR, textStatus, errorThrown) {
								var msg = ' ' + errorThrown;
								jQuery('#woocommerce_avatax_validate_addr_button_result').html(msg).show('300');
					}
				});

				return true;
			}

			function taxnow_use_validated() {
				jQuery('#woocommerce_avatax_origin_street').val(validated_origin_street);
				jQuery('#woocommerce_avatax_origin_city').val(validated_origin_city);
				jQuery('#woocommerce_avatax_origin_state').val(validated_origin_state);
				jQuery('#woocommerce_avatax_origin_country').val(validated_origin_country);

				// zip is already updated
				taxnow_process_validation();
				return true;
			}

		</script>

		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $field ); ?>"><?php //echo wp_kses_post( $data['title'] ); ?></label>
				<?php echo $this->get_tooltip_html( $data ); ?>
			</th>
			<td class="forminp">
				<fieldset>
					<legend class="screen-reader-text"><span><?php echo wp_kses_post( $data['title'] ); ?></span></legend>
					<button class="<?php echo esc_attr( $data['class'] ); ?>" type="button" name="<?php echo esc_attr( $field ); ?>" id="<?php echo esc_attr( $field ); ?>" style="<?php echo esc_attr( $data['css'] ); ?>"<?php echo $this->get_custom_attribute_html( $data ); ?>><?php echo wp_kses_post( $data['title'] ); ?></button>
					<?php echo $this->get_description_html( $data ); ?>
				</fieldset>
				<br/>
				<div id="<?php echo esc_attr( $field ) . '_result'; ?>" style="background-color:#ffffe0;border:1px #e6db55 solid; padding:4px; font-size:11px; display:none; width:340px;"></div>
			</td>
		</tr>
		<?php
		return ob_get_clean();
	}


	/**
	 * Generate Title HTML.
	 */
	public function generate_title_html( $key, $data ) {
		$defaults = array(
			'title'             => '',
			'class'             => ''
		);
		$data = wp_parse_args( $data, $defaults );
		ob_start();
		?>
			</table><div style="width: 50%; background-color: lightgray; padding: 1px; padding-left: 15px;">
			<h3 class="wc-settings-sub-title <?php echo esc_attr( $data['class'] ); ?>"><?php echo wp_kses_post( $data['title'] ); ?></h3>
			<?php if ( ! empty( $data['description'] ) ) : ?>
				<p><?php echo wp_kses_post( $data['description'] ); ?></p>
			<?php endif; ?>
			</div><table class="form-table">
		<?php
		return ob_get_clean();
	}
	
	
}

endif;
