<?php

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}


class WC_Avalara extends WC_Avalara_Base

{



	public $tn_option_prefix = 'tnwoo_';

	public $main_template_file = 'template-wc-avatax-checkout.php';

	public $checkout_js_file = 'template-wc-avatax-checkout.js';	// ** to do

	public $init_event = 'woocommerce_init';	// used in _construct

	public $ecomm_class = 'Woocommerce';

	public $ecomm_name = 'WooCommerce';

	public $ecomm_post_content = '[woocommerce_checkout]';

	

	public $checkout_flds;		// used in address template

	public $required_flds;		// used in address template

	

	private $default_doc_code = 'Order-';	// this is what is passed into Avalara, example, "Order-216" where 216 is the ID generated from WC



	private $tax_calc_filter_option;

	private $tax_calc_filter_list;

	private $disable_tax_calc;

	private $addr_filter_option;

	private $addr_filter_list;

	private $disable_addr_validation;
	private $tax_discount;
	private $cust_code_name;
	private $discount_desc;

	// Added in v2.3
	private $commit_action;
	private $enable_exempt_id;


	// ============================================================

    public function do_taxnow_activate()

    {

		$this->validate_ecomm_plugin();	// if it doesn't validate, it won't return



		$this->init_constants();



		$pre = $this->tn_option_prefix;

		

        update_option( $pre.'checkout_post_id', $this->post_id );

		

        // ----------------------------------------

        // Set defaults (if not set)

        // ----------------------------------------

	// should no longer need these options due to WC_Integrations page, so delete the leftover settings
	
	    delete_option('$pre.default_tax_code');
	    delete_option( $pre.'default_freight_code' );
            delete_option( $pre.'avalara_url' );
            delete_option( $pre.'disable_tax_calc' );
            delete_option( $pre.'disable_addr_validation' );
            delete_option( $pre.'tax_discount' );
            delete_option( $pre.'cust_code_name' );
	    delete_option( $pre.'discount_desc' );	

	// original "default settings" code below is saved for reference
/*
		if( get_option( $pre.'default_tax_code','not_set' ) == 'not_set' )

            update_option( $pre.'default_tax_code', 'P0000000' );



		if( get_option( $pre.'default_freight_code','not_set' ) == 'not_set' )

            update_option( $pre.'default_freight_code', 'FR' );

		

		if( get_option( $pre.'avalara_url','not_set' ) == 'not_set' )

            update_option( $pre.'avalara_url', 'https://avatax.avalara.net/' );



		if( get_option( $pre.'disable_tax_calc','not_set' ) == 'not_set' )

            update_option( $pre.'disable_tax_calc', 'no' );



		if( get_option( $pre.'disable_addr_validation','not_set' ) == 'not_set' )

            update_option( $pre.'disable_addr_validation', 'no' );



		if( get_option( $pre.'tax_discount','not_set' ) == 'not_set' )

            update_option( $pre.'tax_discount', 'no' );


		if( get_option( $pre.'cust_code_name','not_set' ) == 'not_set' )

            update_option( $pre.'cust_code_name', 'no' );

		if( get_option( $pre.'discount_desc','not_set' ) == 'not_set' )
			update_option( $pre.'discount_desc','Discount' );	
*/
			
			
		// depreciated in 1.0 install (some really old installs)

		delete_option('tnwoo_disable_address_validation');

		delete_option('tnwoo_disable_tax_calc');

		delete_option('tnwoo_taxnow_origin_zip');

		

		// depreciated in 2.0

		delete_option( $pre.'reduce_ad_label');

		delete_option( $pre.'show_tax_details');

		delete_option( $pre.'tnwoo_show_tax_details');		// remove error entry

		// delete_option( $pre.'disable_tax_calc');		// at one point we switched how this worked. retained the old one for reference.

		delete_option( $pre.'enable_tax_calc');

		delete_option( $pre.'enable_address_validation');	// now called disable_addr_validation

		

		global $wpdb;

		// these may exists from really old installs, no need to keep around

		$wpdb->query("DELETE FROM wp_postmeta WHERE meta_key = '_TNtaxcode'");

		$wpdb->query("DELETE FROM wp_postmeta WHERE meta_key = '_TNfreightcode'");

		// these need to be updated else they show up twice on the Product edit screen

		$wpdb->query("UPDATE wp_postmeta SET meta_key = '_taxnow_taxcode' WHERE meta_key = 'TN_taxcode'");

		$wpdb->query("UPDATE wp_postmeta SET meta_key = '_taxnow_freightcode' WHERE meta_key = 'TN_freightcode'");

		

    } // on_taxnow_activate()



	// ============================================================

	public function do_taxnow_deactivate()
	{

		global $wp_rewrite;

		$wp_rewrite->flush_rules();

	}

	

	// ============================================================

	public function do_taxnow_uninstall()
	{

		// nothing here, reserved for future when we have an uninstaller

	}



	// ============================================================

	public function init()

	{

		// plugin initialization, occurs after WooCommerce is initialization



		// load contstants

		$this->init_constants();



		// set main template file (front end)

		$this->main_template_file = $this->get_template_file_path();



		// check for config issues

		$this->scan_configuration_taxnow();

		$this->scan_configuration_ecommplugin();



		// load admin class

		if (is_admin())

			require_once TN_WOO_FILE_PATH . '/class-wc-avalara-admin.php';



		// load include files

		require_once TN_WOO_FILE_PATH . '/wc-avalara-functions.php';

			

		// load classes now for use later

		$this->obj_taxnow_data = new WC_Avalara_Data;


		if( ! is_admin() )

			{

			add_filter( 'the_content', array( $this, 'show_checkout_page_logic' ), 10 );

			}

		else

			{

			// when a status is changed by store admin, we need to process the transaction to Avalara

			// this status hook may be causing double commits. test if this or completed status can be removed.
			add_action('woocommerce_order_status_processing', array($this, 'handle_payment_completed'));

			add_action('woocommerce_order_status_completed', array($this, 'handle_payment_completed'));

			add_action('woocommerce_order_status_refunded', array($this, 'handle_payment_refunded'));

			add_action('woocommerce_order_status_cancelled', array($this, 'handle_payment_cancelled'));

			}



		// when a payment is completed in Woo, we need to commit the transaction to Avalara

		add_action('woocommerce_payment_complete', array($this, 'handle_payment_completed'));

		add_action('woocommerce_checkout_update_order_meta', array($this, 'taxnow_update_woo_order_meta'));



		// for intergration into one page checkout

		add_action('woocommerce_review_order_before_order_total',array($this, 'review_order_update') );

		// for Tax Discount sales - applied after tax
		// commented out for now but eventually we prefer to do it this way
		//add_filter('woocommerce_cart_discounts_after_tax', array($this, 'handle_after_tax_discount') );


		// add taxes during any calulation
		// commented out for now | 5.14.2013 - eventually we want to do it this way instead
		//add_filter( 'woocommerce_get_order_item_totals', array($this, 'tax_now_get_order_item_totals'),10,2);

		// insert exemption id into checkout form - v2.3
		add_action( 'woocommerce_after_checkout_billing_form', array($this, 'checkout_exempt_id') );

		// show exemption id on admin order details page
		add_action( 'woocommerce_admin_order_data_after_billing_address', array($this, 'exempt_id_display_admin_order_detail'), 10, 1 );

		// set class level vars for options
		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$this->tax_calc_filter_option = $settings_array[ 'tax_calc_filter_option' ];
		$this->tax_calc_filter_list = $settings_array[ 'tax_calc_filter_list' ];
		$this->disable_tax_calc = $settings_array[ 'disable_tax_calc' ];
		$this->addr_filter_option = $settings_array[ 'addr_filter_option' ];
		$this->addr_filter_list = $settings_array[ 'addr_filter_list' ];
		$this->disable_addr_validation = $settings_array[ 'disable_addr_validation' ];
		$this->tax_discount = $settings_array[ 'tax_discount' ];
		$this->cust_code_name = $settings_array[ 'cust_code_name' ];
		$this->discount_desc = $settings_array[ 'discount_desc' ];
		$this->commit_action = $settings_array[ 'commit_action' ];
		$this->enable_exempt_id = $settings_array[ 'enable_exempt_id' ];

		// Display admin warnings in a banner at the top of the admin page
		add_action( 'admin_notices', array($this, 'set_admin_message') );

	} // init()


	// ============================================================
	// Stores admin warning messages in a persistent WP option setting.
	// This is a temporary workaround. Messages are erased after display.

	public function set_admin_message()
	{
		$settings_array = get_option( 'woocommerce_avatax_settings' );
		if ( isset( $settings_array[ 'admin_message' ] ) )
		    $message = $settings_array[ 'admin_message' ];
		else
		    $message = '';
		if ($message != '') echo '<div class="error"><p>' . $message . '</p></div>';
		$settings_array[ 'admin_message' ] = '';
		update_option( 'woocommerce_avatax_settings', $settings_array );
	}

	// ============================================================

	private function init_constants()

	{



		// double check to see if this function was already called during installation

		if( defined('TN_WOO_VERSION') )

			return;



		// Set the core constansts

		define('TN_WOO_VERSION', $this->get_version() );

		define('TN_WOO_FILE_NAME',__FILE__);

		define('TN_WOO_FILE_PATH',dirname(__FILE__));

		define('TN_WOO_DIR_NAME', basename(TN_WOO_FILE_PATH));

		define('TN_WOO_FOLDER',   dirname( plugin_basename( __FILE__ ) ) );

		define('TN_WOO_URL',      plugins_url( '', __FILE__ ) );

		

		// set additional constants

		

		define('TN_WOO_URL_PARAM_STEP', 'step');

		define('TN_WOO_URL_PARAM_EXTRA', 'extra');

		

		define('TN_WOO_STEP_CART', 'cart');

		define('TN_WOO_STEP_LOGIN','login');

		define('TN_WOO_STEP_ADDRESS','address');

		define('TN_WOO_STEP_SHIPPING','shipping');

		define('TN_WOO_STEP_TAX','tax');

		define('TN_WOO_STEP_PAYMENT','payment');

		define('TN_WOO_FORM_REGISTER','register');

		define('TN_WOO_FORM_LOGIN','login');

		//define('TN_WOO_FORM_LOGGED','logged');

		

		define ('TN_WOO_OPT_PREFIX', $this->tn_option_prefix);	// for WP option and multiple cart support

	}



	// ============================================================

	public function scan_configuration_ecommplugin()

	{

		// look for config issues that may cause the checkout system to not work

		// these are specific to Woo Commerce, additional checks are performed in the base class function scan_configuration_taxnow



		$op = $this->tn_option_prefix;	// simplify

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		if ( $settings_array[ 'disable_tax_calc' ] == 'no' && get_option( 'woocommerce_calc_taxes' ) == 'yes' )

			$this->add_config_warning('Warning: TaxNOW AND Woo Commerce are both set to calculate taxes. Please disable one or the other.');

	}



	// reserved for future

	public function tax_now_get_order_item_totals($total_rows, $order)

		{

		// lookup up saved values here

		}


	// ---------------------------------
	// insert Sales Tax or VAT exemption id field into checkout form billing fields
	public function checkout_exempt_id( $checkout )
	{
	   if ($this->enable_exempt_id != 'n')
	   {
		if ($this->enable_exempt_id == 'b')
			$label_text = 'Business VAT ID';
		else
			$label_text = 'Sales Tax Exempt ID';
		echo '<div id="exempt_id_checkout_field">';
		woocommerce_form_field( 'exempt_id', array(
			'type'		=> 'text',
			'label'		=> __($label_text),
			'class'		=> array('form-row-wide')
		), $checkout->get_value( 'exempt_id' ));
		echo '</div>';
	   }
	}			

	// ---------------------------------
	// show exemption id number on the admin order details page
	public function exempt_id_display_admin_order_detail($order)
	{
		echo '<p><strong>'.__('Tax or VAT Exemption ID').':</strong> ' . get_post_meta( $order->id, 'exempt_id', true ) . '</p>';
	}

	// ---------------------------------

	public function review_order_update()

	{



		$default_html = '

			<tr style="display:none;"><th>data storage</th>

				<td>

				<span id="taxnow_shipping_address_1"></span>

				<span id="taxnow_shipping_city"></span>

				<span id="taxnow_shipping_state"></span>

				<span id="taxnow_shipping_postcode"></span>
				<span id="taxnow_shipping_country"></span>

				<span id="taxnow_message">no action</span>

				</td>

			</tr>';



		global $woocommerce;

		$woocommerce_checkout = $woocommerce->checkout();

		$woocommerce_cart = $woocommerce->cart;

		$woocommerce_cart_contents = $woocommerce_cart->cart_contents;

		$cart_total = $woocommerce->cart->total;

		$discount_pretax = $woocommerce->cart->discount_cart;


		$woocommerce_customer = $woocommerce->customer;

		// Capture the Exemption ID
		$exemption_id = '';
		if ( ! empty( $_POST['post_data'] ) )
		{
			$post_data = explode('&', $_POST['post_data']);
			foreach($post_data as $pair)
			{
				$pair = explode( '=', $pair);
				$post_data[$pair[0]] = urldecode($pair[1]);
			}
			if ( ! empty( $post_data['exempt_id'] ) )
				$exemption_id = $post_data['exempt_id'];
		}
		$_POST['exempt_id'] = $exemption_id;

		if ($this->tax_calc_filter_option == 'yes')

			$tax_calc_filter_option = true;

		else

			$tax_calc_filter_option = false;

		

		if ($this->disable_tax_calc == 'yes')

			$disable_tax_calc = true;

		else

			$disable_tax_calc = false;



		if ($this->addr_filter_option == 'yes')

			$addr_filter_option = true;

		else

			$addr_filter_option = false;

		

		if ($this->disable_addr_validation == 'yes')

			$disable_addr_validation = true;

		else

			$disable_addr_validation = false;

		if ($this->tax_discount == 'yes')
			$tax_discount = true;
		else
			$tax_discount = false;



		// check for address filtering

		$shipping_country = $woocommerce_customer->shipping_country;

		if($addr_filter_option == false)
		    $restrictions = array(0 => 'US', 1 => 'CA');

		else
		    $restrictions = $this->addr_filter_list;

		$key = array_search($shipping_country, $restrictions);		// look for customer's country in filter list


		if ($key === false || $disable_addr_validation)	// if country is not active or addresses are disabled then exit

			{

			echo '<tr style="display:none;"><th>addr validation logic</th><td>skipped</td></tr>';

			echo '

			<tr style="display:none;"><th>data storage</th>

			<td><!--(0)-->

			<span id="taxnow_shipping_address_1"></span>

			<span id="taxnow_shipping_city"></span>

			<span id="taxnow_shipping_state"></span>

			<span id="taxnow_shipping_postcode"></span>
			<span id="taxnow_shipping_country"></span>

			<span id="taxnow_message">no action</span>

			</td>

			</tr>

			';

			}



		else		// do addr validation

			{

		// check that we have address information

		if ($woocommerce_customer->shipping_address == '' 

					|| $woocommerce_customer->shipping_city == ''

					|| $woocommerce_customer->shipping_state == ''

					|| $woocommerce_customer->shipping_country == ''

					|| $woocommerce_customer->shipping_postcode == ''
					|| $woocommerce_customer->shipping_country == '' )

			{

			echo $default_html;

				// return;

			}

		else	{

			$response = $this->checkout_address_validation();

			if ($response['is_valid'] == '0')

				{
				echo '<tr><th>Tax</th><td>Please enter your shipping address or select "Ship to billing address"</td></tr>';

				echo '

					<tr style="display:none;"><th>data storage</th>

					<td><!--(1)-->

					<span id="taxnow_shipping_address_1"></span>

					<span id="taxnow_shipping_city"></span>

					<span id="taxnow_shipping_state"></span>

					<span id="taxnow_shipping_postcode"></span>
					<span id="taxnow_shipping_country"></span>

					<span id="taxnow_message">addr not valid</span>

					</td>

					</tr>';
				return;

				}

			elseif ($response['is_valid'] == '1')

				{

				if ($response['is_different'] == '0')

					{

					echo '

					<tr style="display:none;"><th>data storage</th>

					<td>(2)

					<span id="taxnow_shipping_address_1"></span>

					<span id="taxnow_shipping_city"></span>

					<span id="taxnow_shipping_state"></span>

					<span id="taxnow_shipping_postcode"></span>
					<span id="taxnow_shipping_country"></span>

					<span id="taxnow_message">addr not different</span>

					</td>

					</tr>';

					}

				else

					{

					echo '

					<tr style="display:none;"><th>data storage</th>

					<td><!--(3)-->

					<span id="taxnow_shipping_address_1">'.$response['GetLine1'].'</span>

					<span id="taxnow_shipping_city">'.$response['GetCity'].'</span>

					<span id="taxnow_shipping_state">'.$response['GetRegion'].'</span>

					<span id="taxnow_shipping_postcode">'.$response['GetPostalCode'].'</span>
					<span id="taxnow_shipping_country">'.$response['GetCountry'].'</span>

					<span id="taxnow_message">addr update</span>

					</td>

					</tr>';

					}

				}

			else

				{

				// should not be a scenario

					echo '

					<tr style="display:none;"><th>data storage</th>

					<td><!--(3)-->

					<span id="taxnow_shipping_address_1">'.$response['GetLine1'].'</span>

					<span id="taxnow_shipping_city">'.$response['GetCity'].'</span>

					<span id="taxnow_shipping_state">'.$response['GetRegion'].'</span>

					<span id="taxnow_shipping_postcode">'.$response['GetPostalCode'].'</span>
					<span id="taxnow_shipping_country">'.$response['GetCountry'].'</span>

					<span id="taxnow_message">Validation process failed</span>

					</td>

					</tr>';

				}

			}

			}



		// check for tax calculation filtering

		$shipping_state = $woocommerce_customer->shipping_state;

		$restrictions = (array)$this->tax_calc_filter_list;    
		
		$key = array_search($shipping_state, $restrictions);		// look for customer's state in filter list

		if (($tax_calc_filter_option == true && $key === false) || $disable_tax_calc == true)	// if state is not active or tax is disabled then exit

			{

			echo $default_html;

			return;

			}

		else		// begin tax calculation logic

			{



		// check that we have address information

		if ($woocommerce_customer->shipping_address == '' 

					|| $woocommerce_customer->shipping_city == ''

					|| $woocommerce_customer->shipping_state == ''

					|| $woocommerce_customer->shipping_country == ''

					|| $woocommerce_customer->shipping_postcode == ''
					|| $woocommerce_customer->shipping_country == '' )

			{

			echo '<tr><th>Tax</th><td>Please enter your shipping address or select "Ship to billing address"</td></tr>';

			echo $default_html;

			return;

			}

		else	{

		$cart_lines = array();		// create empty array to be populated later

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$global_tax_code = $settings_array[ 'default_tax_code' ];

		foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $lineitem_values )

			{

			$item_productid = $lineitem_values['product_id'];

			$_product = get_product( $item_productid );
			if ($_product->sku) $item_code = $_product->sku;

			else $item_code = $lineitem_values['product_id'];

			if ($_product->post->post_title) $item_desc = $_product->post->post_title;
			else $item_desc = $item_code;
			$item_quantity = $lineitem_values['quantity'];

			$item_price = $lineitem_values['line_subtotal'];

			

			// look for item specific codes

			$item_taxcode = get_post_meta( $item_productid, '_taxnow_taxcode', true );

			$item_freightcode = get_post_meta( $item_productid, '_taxnow_freightcode', true );



			if ( $item_taxcode )

				$tax_code = $item_taxcode;

			else

				$tax_code = $global_tax_code;

			// create new tax line

			$product_lineitem = new WC_Avalara_Lineitem();

			  $product_lineitem->set_item_code( $item_code );

			  $product_lineitem->set_item_name( $item_code );

			  $product_lineitem->set_description( $item_desc );

			  $product_lineitem->set_tax_code( $tax_code );

			  $product_lineitem->set_quantity( $item_quantity );

			  $product_lineitem->set_unit_price( $item_price );  // really the line total, not unit price
			  if ($discount_pretax && $discount_pretax > 0) $product_lineitem->set_discounted( 1 ); // line items are flagged true if order discount applies
			  $product_lineitem->set_item_key($cart_item_key);

			$cart_lines[] = $product_lineitem;



			}



		if (get_option('woocommerce_calc_shipping') == 'yes')

			{

			// --- Add Shipping line

			$woocommerce->cart->calculate_totals();

			$shipping = $woocommerce->cart->shipping_total;

			$product_lineitem = new WC_Avalara_Lineitem();

			  $product_lineitem->set_item_code( 'Shipping' );

                          $product_lineitem->set_item_name( 'Shipping' );

			  $product_lineitem->set_description( 'Shipping' );

    	  		$settings_array = get_option( 'woocommerce_avatax_settings' );
			  $product_lineitem->set_tax_code( $settings_array[ 'default_freight_code' ] );		// if option not set, default value is FR

			  $product_lineitem->set_unit_price( $shipping );

			$cart_lines[] = $product_lineitem;

			}

		$email = '<Unknown>';

		$necessary_fields = array(

			'Line1' => true,

			'City' => true,

			'Region' => true,

			'PostalCode' => true,
			'Country' => true

		);



		$addr = array();

		$addr['Line1'] = $woocommerce_customer->shipping_address;

		$addr['City'] = $woocommerce_customer->shipping_city;

		$addr['Region'] = $woocommerce_customer->shipping_state;

		$addr['PostalCode'] = $woocommerce_customer->shipping_postcode;

		$addr['Country'] = $woocommerce_customer->shipping_country;

		// --- Calculate taxes
		if ($this->calc_tax( $email, $addr, $cart_lines, $discount_pretax, $exemption_id, $this->enable_exempt_id) )

			{

			$this->obj_taxnow_data->set_tax_data( $cart_lines );	// save in Session var

			}

		else

			$this->add_frontend_msg($this->get_error_msgs());



		$tax_lines = $this->obj_taxnow_data->get_tax_lines();

		$cart_tax_total = 0;

		$shipping_tax_total = 0;

		foreach( $tax_lines as $individual_line )

		   {
			if (isset($woocommerce->cart->cart_contents[$individual_line->get_item_key()]))
			{
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax'] = $individual_line->get_tax_amount();
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_subtotal_tax'] = $individual_line->get_tax_amount();

				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax_data']['total'][1] = wc_format_decimal( $individual_line->get_tax_amount() );
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax_data']['subtotal'][1] = wc_format_decimal( $individual_line->get_tax_amount() );
			}

			if ($individual_line->get_item_code() == 'Shipping')
				$shipping_tax_total += $individual_line->get_tax_amount();
			else
				$cart_tax_total += $individual_line->get_tax_amount();
		   }



		$total_tax = $cart_tax_total + $shipping_tax_total;

		$cart_total += $total_tax;


		if (!$tax_discount)
		{
			$woocommerce->cart->cart_session_data['tax_total'] = $cart_tax_total;
			$woocommerce->cart->tax_total = $cart_tax_total;

			$woocommerce->cart->cart_contents_tax = $cart_tax_total;

			$woocommerce->cart->cart_session_data['shipping_tax_total'] = $shipping_tax_total;		
			$woocommerce->cart->shipping_tax_total = $shipping_tax_total;		

			$woocommerce->cart->total = $cart_total;
			$woocommerce->cart->cart_session_data['total'] = $cart_total;

			$woocommerce->cart->subtotal = $cart_total;
			$woocommerce->cart->taxes[1] = $cart_tax_total;
			$woocommerce->cart->shipping_taxes[1] = $shipping_tax_total;

			$woocommerce->cart->cart_session_data['taxes'][1] = $cart_tax_total;
			$woocommerce->cart->cart_session_data['shipping_taxes'][1] = $shipping_tax_total;
		}

		// woocommerce_update_order_item_meta


		echo '

			<tr class="tax-rate">

				<th>Tax</th>

				<td><span class="amount">'.woocommerce_price($total_tax).'</span></td>

			</tr>';
		if ($tax_discount)
		{
			$woocommerce->cart->discount_total += $total_tax;
			echo '<tr class="tax-rate"><th>'.$this->discount_desc.'</th><td><span class="amount">(-'.woocommerce_price($total_tax).')</span></td></tr>';
		}


		}

		}	// end tax calculation logic

	}



	// ============================================================

	public function show_checkout_page_logic( $content = '' )

	{

		if (is_checkout())		// this is a woo function

			{

			// only include when validation is turned on | 2.0.1
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			if ($settings_array[ 'disable_addr_validation' ] == 'no' )

				{

				require( $this->main_template_file );

				//wp_enqueue_script( 'taxnow', $this->checkout_js_file );  // want to try switching to a js file at some point

				}

			}

		return $content;	

	}





	// =================================================

	// called on woo hook to add tax to order

	public function taxnow_update_woo_order_meta($order_id)

	{

		$woo_order = new WC_Order($order_id);



		// check for state filtering

		if ($this->is_order_state_filtered($order_id) || $this->disable_tax_calc == 'yes')

			return;



		global $woocommerce;

		$woocommerce_cart = $woocommerce->cart;

		$woocommerce_cart_contents = $woocommerce_cart->cart_contents;

		$cart_total = $woocommerce->cart->total;

		$woocommerce_customer = $woocommerce->customer;

		$discount_pretax = $woocommerce->cart->discount_cart;

		$cart_tax_total = 0;

		$shipping_tax_total = 0;

		$cart_lines = array();		// create empty array to be populated later

	    	$settings_array = get_option( 'woocommerce_avatax_settings' );
		$global_tax_code = $settings_array[ 'default_tax_code' ];

		// Capture and save the Exemption ID
		$exemption_id = '';
		if ( ! empty( $_POST['exempt_id'] ) )
		{
			$exemption_id = $_POST['exempt_id'];
			update_post_meta( $order_id, 'exempt_id', $exemption_id );
		}

		foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $lineitem_values )

			{
			$item_productid = $lineitem_values['product_id'];

			$_product = get_product( $item_productid );
			if ($_product->sku) $item_code = $_product->sku;

			else $item_code = $lineitem_values['product_id'];

			if ($_product->post->post_title) $item_desc = $_product->post->post_title;
			else $item_desc = $item_code;
			$item_quantity = $lineitem_values['quantity'];

			$item_price = $lineitem_values['line_subtotal'];



			// look for item specific codes

			$item_taxcode = get_post_meta( $item_productid, '_taxnow_taxcode', true );

			$item_freightcode = get_post_meta( $item_productid, '_taxnow_freightcode', true );



			if ( $item_taxcode )

				$tax_code = $item_taxcode;

			else

				$tax_code = $global_tax_code;



			$product_lineitem = new WC_Avalara_Lineitem();

			  $product_lineitem->set_item_code( $item_code );

			  $product_lineitem->set_item_name( $item_code );

			  $product_lineitem->set_description( $item_desc );

			  $product_lineitem->set_tax_code( $tax_code );

			  $product_lineitem->set_quantity( $item_quantity );

			  $product_lineitem->set_unit_price( $item_price );  // really the line total, not unit price

			  if ($discount_pretax && $discount_pretax > 0) $product_lineitem->set_discounted( 1 ); // line items are flagged true if order discount applies
			  $product_lineitem->set_item_key ($cart_item_key);

			$cart_lines[] = $product_lineitem;

			}


		if (get_option('woocommerce_calc_shipping') == 'yes')

			{

			$woocommerce->cart->calculate_totals();

			$shipping = $woocommerce->cart->shipping_total;

			$product_lineitem = new WC_Avalara_Lineitem();

			  $product_lineitem->set_item_code( 'Shipping' );

                          $product_lineitem->set_item_name( 'Shipping' );

			  $product_lineitem->set_description( 'Shipping' );

	     		$settings_array = get_option( 'woocommerce_avatax_settings' );
			  $product_lineitem->set_tax_code( $settings_array[ 'default_freight_code' ] );		// if option not set, default value is FR

			  $product_lineitem->set_unit_price( $shipping );

			$cart_lines[] = $product_lineitem;

			}

		$email = $woo_order->billing_email;
		//'<Unknown>';

		$necessary_fields = array(

			'Line1' => true,

			'City' => true,

			'Region' => true,

			'PostalCode' => true,
			'Country' => true

		);



		// Check if shipping address is blank and use billing instead - JMA 2013-09-14
		if (!$woo_order->shipping_address_1) {
			$addr = array(
				'Line1' => $woo_order->billing_address_1,
				'City' => $woo_order->billing_city,
				'Region' => $woo_order->billing_state,
				'PostalCode' => $woo_order->billing_postcode,
				'Country' => $woo_order->billing_country
				);
			}
		else {
			$addr = array(
				'Line1' => $woo_order->shipping_address_1,
				'City' => $woo_order->shipping_city,
				'Region' => $woo_order->shipping_state,
				'PostalCode' => $woo_order->shipping_postcode,
				'Country' => $woo_order->shipping_country
				);
			}

// Old method only used Billing Address. Removed JMA 2013-09-14. Retained for reference.
//		$addr = array();
//		$addr['Line1'] = $woocommerce_customer->address;
//		$addr['City'] = $woocommerce_customer->city;
//		$addr['Region'] = $woocommerce_customer->state;
//		$addr['PostalCode'] = $woocommerce_customer->postcode;

		if( $this->calc_tax( $email, $addr, $cart_lines, $discount_pretax, $exemption_id, $this->enable_exempt_id ) )

			$this->obj_taxnow_data->set_tax_data( $cart_lines );	// save in Session var

		else

			$this->add_frontend_msg($this->get_error_msgs());



		$tax_lines = $this->obj_taxnow_data->get_tax_lines();

		$cart_tax_total = 0;

		$shipping_tax_total = 0;

		foreach( $tax_lines as $individual_line )

			{

			if (isset($woocommerce->cart->cart_contents[$individual_line->get_item_key()]))
			{
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax'] = $individual_line->get_tax_amount();
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_subtotal_tax'] = $individual_line->get_tax_amount();

				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax_data']['total'][1] = wc_format_decimal( $individual_line->get_tax_amount() );
				$woocommerce->cart->cart_contents[$individual_line->get_item_key()]['line_tax_data']['subtotal'][1] = wc_format_decimal( $individual_line->get_tax_amount() );
			}

			if ($individual_line->get_item_code() == 'Shipping')

				$shipping_tax_total += $individual_line->get_tax_amount();

			else

				$cart_tax_total += $individual_line->get_tax_amount();

			}

		

		$total_tax = $cart_tax_total + $shipping_tax_total;

		$cart_total += $total_tax;

		if ($this->tax_discount != 'yes')
		{

			$woocommerce->cart->cart_session_data['tax_total'] = $cart_tax_total;
			$woocommerce->cart->tax_total = $cart_tax_total;

			$woocommerce->cart->cart_contents_tax = $cart_tax_total;

			$woocommerce->cart->cart_session_data['shipping_tax_total'] = $shipping_tax_total;	
			$woocommerce->cart->shipping_tax_total = $shipping_tax_total;

			$woocommerce->cart->total = $cart_total;
			$woocommerce->cart->cart_session_data['total'] = $cart_total;

			$woocommerce->cart->subtotal = $cart_total;
			$woocommerce->cart->taxes[1] = $cart_tax_total;
			$woocommerce->cart->shipping_taxes[1] = $shipping_tax_total;
//			$woocommerce->cart->discount_total = $total_tax;

			$woocommerce->cart->cart_session_data->taxes[1] = $cart_tax_total;
			$woocommerce->cart->cart_session_data->shipping_taxes[1] = $shipping_tax_total;


		update_post_meta( $order_id, '_order_tax',

			number_format( (float) $cart_tax_total, 2, '.', '' ));

			

		update_post_meta( $order_id, '_order_shipping_tax',

			number_format( (float) $shipping_tax_total, 2, '.', '' ));



		update_post_meta( $order_id, '_order_total',

			number_format( (float) $cart_total, 2, '.', '' ));

	global $wpdb;

	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_items",
		array(
			'order_item_name' 		=> 'TaxNOW Tax',
			'order_item_type' 		=> 'tax',
			'order_id'			=> $order_id
		),
		array(
			'%s', '%s', '%d'
		)
	);

	$item_id = absint( $wpdb->insert_id );

	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_itemmeta",
		array(
			'order_item_id'			=> $item_id,
			'meta_key'			=> 'label',
			'meta_value'			=> 'Tax'
		),
		array(
			'%d', '%s', '%s'
		)
	);

	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_itemmeta",
		array(
			'order_item_id'			=> $item_id,
			'meta_key'			=> 'tax_amount',
			'meta_value'			=> $cart_tax_total
		),
		array(
			'%d', '%s', '%s'
		)
	);

	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_itemmeta",
		array(
			'order_item_id'			=> $item_id,
			'meta_key'			=> 'shipping_tax_amount',
			'meta_value'			=> $shipping_tax_total
		),
		array(
			'%d', '%s', '%s'
		)
	);

	// As of WC 2.2 (introduction of WC_Tax class), the following meta keys are required for taxes to display on thank you page and emails
	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_itemmeta",
		array(
			'order_item_id'			=> $item_id,
			'meta_key'			=> 'rate_id',
			'meta_value'			=> 1
		),
		array(
			'%d', '%s', '%d'
		)
	);

	$wpdb->insert(
		$wpdb->prefix . "woocommerce_order_itemmeta",
		array(
			'order_item_id'			=> $item_id,
			'meta_key'			=> 'compound',
			'meta_value'			=> 0
		),
		array(
			'%d', '%s', '%d'
		)
	);

		}
	}



	// =================================================

	function checkout_address_validation()

	{



		// *** assumes we have data at this point

		global $woocommerce;

		$woocommerce_customer = $woocommerce->customer;
		$str = ''; // messages for logging and message box



		if ($this->disable_addr_validation == 'yes')

			{

				//echo 'Validation disabled';

				return;

			}

		else 
			{
			$shipping_country = $woocommerce_customer->shipping_country;

			if ($this->addr_filter_option == 'yes')
			    $restrictions = $this->addr_filter_list;
			else
			    $restrictions = array(0 => 'US', 1 => 'CA');

			$key = array_search($shipping_country, $restrictions);

			if ($key === false) {

				return;

				}

			}



		$addr = array();

		$field_names = array('shiptobilling', 

			'billing_address_1', 'billing_address_2', 'billing_city', 

			'billing_state', 'billing_country', 'billing_postcode',

			'shipping_address_1', 'shipping_address_2', 'shipping_city', 

			'shipping_state', 'shipping_country', 'shipping_postcode');



		$avalara_fields = array();

		

		$response = array(

			'is_valid' => false,

			'is_different' => false,

			'original_as_string' => array(),

			'validated_as_string' => array(),

			'errors' => array(),

		);



		try

			{

			// note: rebuild this as a foreach...

			$addr['billing_address_1'] = $woocommerce_customer->address;

			$addr['billing_city'] = $woocommerce_customer->city;

			$addr['billing_state'] = $woocommerce_customer->state;

			$addr['billing_postcode'] = $woocommerce_customer->postcode;

			$addr['billing_country'] = $woocommerce_customer->country;


			$addr['shipping_address_1'] = $woocommerce_customer->shipping_address;

			$addr['shipping_city'] = $woocommerce_customer->shipping_city;

			$addr['shipping_state'] = $woocommerce_customer->shipping_state;

			$addr['shipping_postcode'] = $woocommerce_customer->shipping_postcode;

			$addr['shipping_country'] = $woocommerce_customer->shipping_country;


			$addr['shiptobilling'] = '1'; // *** need to double check this

			// and here is the code to do it...
//			foreach ($field_names as $fld)
//				{
//				$addr[$fld] = $checkout_data[$fld];
//				$str = $str.$fld.': '.$checkout_data[$fld].'|';
//				}

			if ( get_option('woocommerce_calc_shipping')=='no')

				{

				$avalara_fields['Line1'] = $addr['billing_address_1'];

				$avalara_fields['City'] = $addr['billing_city'];

				$avalara_fields['Region'] = $addr['billing_state'];

				$avalara_fields['PostalCode'] = $addr['billing_postcode'];
				$avalara_fields['Country'] = $addr['billing_country'];

				$orginal_addr = $addr['billing_address_1'] . ', ' .

					$addr['billing_city'] . ' ' . $addr['billing_state'] . ', ' .

					$addr['billing_postcode'] . ', ' . $addr['billing_country'];

				}

			else

				{

				$avalara_fields['Line1'] = $addr['shipping_address_1'];

				$avalara_fields['City'] = $addr['shipping_city'];

				$avalara_fields['Region'] = $addr['shipping_state'];

				$avalara_fields['PostalCode'] = $addr['shipping_postcode'];

				$avalara_fields['Country'] = $addr['shipping_country'];
				$orginal_addr = $addr['shipping_address_1'] . ', ' .

					$addr['shipping_city'] . ' ' . $addr['shipping_state'] . ', ' .

					$addr['shipping_postcode'] . ', ' . $addr['shipping_country'];

				}



			$valid_address_obj = $this->validate_address($avalara_fields);

			

			if( $valid_address_obj && is_object($valid_address_obj) )

				{

				$str = $str.'<br>WE HAVE A VALID ADDRESS';

				$response['is_valid'] = true;

				}

			else

				{

				$str = $str.'<br>WE DO NOT HAVE A VALID ADDRESS';

				$response['is_valid'] = false;

				}

			$str = '';

			

			$response['original_as_string'] = $orginal_addr;

			if( is_object( $valid_address_obj ) )

				{

				foreach ( array('GetLine1', 'GetCity', 'GetRegion', 'GetPostalCode', 'GetCountry') as $function)

					{

					$str = $str.$valid_address_obj->$function();

					if ($function=='GetLine1' || $function=='GetRegion')

						$str = $str.', ';

					else if ($function=='GetCity')

						$str = $str.' ';


					$response[$function] = $valid_address_obj->$function();

					}

			

				$response['validated_as_string'] = $str;

				

				if ($orginal_addr != $str)

					$response['is_different'] = true;

				}



			

			$response['errors'] = NULL;

			return $response;

			
			// saved for reference in case we need it again
			// allows us to store the validated address and get user confirmation
			if ($response['is_different'])

				{

				// echo '<tr><th>address check response</th><td>prompt user to update address</td></tr>';

				// echo '<tr><th>response</th><td>'; print_r($response); echo '</td></tr>';

				// echo '<tr style="display:none;"><th>data storage</th>

				//	<td>

				//	<span id="taxnow_billing_address_1">'.$response['GetLine1'].'</span>

				//	<span id="taxnow_billing_city">'.$response['GetCity'].'</span>

				//	<span id="taxnow_billing_state">'.$response['GetRegion'].'</span>

				//	<span id="taxnow_billing_postcode">'.$response['GetPostalCode'].'</span>

				//	<span id="taxnow_action">address returned</span>

				// </tr>';

				}

			//exit;				

			}

		catch (exception $e)

			{

			// if we get an error during the AvaTax call, make it visible to the customer
			echo '<tr><th>response</th><td>'; print_r($response); echo '</td></tr>';

			}

		// return $response;

		return;

	}



	// ============================================================

	public function handle_payment_completed($order_id)

	{	// called through Woo hook

		// check for state filtering
		if ($this->is_order_state_filtered($order_id))

			return;

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$commit_action = $settings_array[ 'commit_action' ];

		if ($commit_action == 'n')
			return;
		else if ($commit_action == 'u')
			$tx_commit = 'false';
		else
			$tx_commit = 'true';

		$this->handle_payment_commit($order_id, 'SalesInvoice', $tx_commit);

	}



	// ============================================================

	public function handle_payment_refunded($order_id)

	{	// called through Woo hook

		// check for state filtering
		if ($this->is_order_state_filtered($order_id))

			return;

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$commit_action = $settings_array[ 'commit_action' ];

		if ($commit_action == 'n')
			return;
		else if ($commit_action == 'u')
			$tx_commit = 'false';
		else
			$tx_commit = 'true';

		$this->handle_payment_commit($order_id, 'ReturnInvoice', $tx_commit);

		// Warn user not to cancel a refunded order
		$message = 'Warning: Please check your AvaTax console to verify that this order has not been previously Cancelled.';

		update_option($this->tn_option_prefix.'admin_message', $message);
	}



	// ============================================================

	public function handle_payment_cancelled($order_id)

	{	// called through Woo hook

		// check for state filtering
		if ($this->is_order_state_filtered($order_id))

			return;

		// eventually will add check to see if order was committed previously

		$default_doc_code = 'Order-';	// this is what is passed into Avalara, example, "Order-216" where 216 is the ID generated from WC

		$doc_code = $default_doc_code . $order_id;

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$commit_action = $settings_array[ 'commit_action' ];

		if ($commit_action == 'n')
			return;

		$this->cancel_request($doc_code);

		// Warn user not to refund a cancelled order
		$message = 'Warning: Please check your AvaTax console to verify that this order has not been previously Refunded.';
		update_option($this->tn_option_prefix.'admin_message', $message);
	}



	// ============================================================

	private function handle_payment_commit($order_id, $order_type, $tx_commit)

	{

		// check to see if order was committed previous to this
		$commit = get_post_meta( $order_id, '_taxnow_avalaracommit', 1);

		if ($order_type == 'SalesInvoice' && $commit == 'sales')

			{

			return;		// don't commit twice

			// maybe add to notes that second commit was attempted

			}

		else if ($order_type == 'ReturnInvoice' && $commit == 'return')
			{
			return;
			}
		else if ($order_type == 'SalesInvoice' && $commit == 'true') // for backward compatibility
			{
			return;
			}


		$woo_order = new WC_Order($order_id);

		$default_doc_code = 'Order-';	// this is what is passed into Avalara, example, "Order-216" where 216 is the ID generated from W/C
		$doc_code = $default_doc_code . $order_id;

		if ( $order_type == 'ReturnInvoice' )		// need to get order date for a refund

			{

			$order_date = $woo_order->order_date;

			$order_date = substr($order_date, 0, strpos($order_date,' '));

			}

		if ($this->cust_code_name == 'no')
		{

			$customer_email = $woo_order->billing_email;		// added option to toggle JMA 2013-10-28
		}
		else
		{

			$customer_email = $woo_order->billing_first_name . ' ' . $woo_order->billing_last_name;
		}

		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$global_tax_code = $settings_array[ 'default_tax_code' ];
		$enable_exempt_id = $settings_array[ 'enable_exempt_id' ];
		$tx_type = $settings_array[ 'commit_action' ];

		// Capture the Exemption ID
		$exemption_id = get_post_meta( $order_id, 'exempt_id', 1);
		if (! is_string( $exemption_id ) )
			$exemption_id = $exemption_id[0];

		// Check if shipping address is blank and use billing instead - JMA 2013-07-24
		if (!$woo_order->shipping_address_1) {
			$address = array(

				'Line1' => $woo_order->billing_address_1,

				'City' => $woo_order->billing_city,

				'Region' => $woo_order->billing_state,

				'PostalCode' => $woo_order->billing_postcode,
				'Country' => $woo_order->billing_country
				);
			}
		else {

			$address = array(

				'Line1' => $woo_order->shipping_address_1,

				'City' => $woo_order->shipping_city,

				'Region' => $woo_order->shipping_state,

				'PostalCode' => $woo_order->shipping_postcode,
				'Country' => $woo_order->shipping_country
				);
			}

		// Check for a pre-tax discount
		$discount_pretax = $woo_order->cart_discount;
		if ($discount_pretax && $discount_pretax > 0) $discounted = 1;
		else $discounted = 0;


		$line_items = $woo_order->get_items();

		foreach ( (array)$line_items as $line_item )

			{

			$_product = $woo_order->get_product_from_item( $line_item );



			$item_productid = $_product->id; 

			if ($_product->sku)

				$item_code = $_product->sku;

			else

				$item_code = $_product->id;
			$item_desc = $_product->post->post_title;

			

			// look for item specific codes

			$item_taxcode = get_post_meta( $item_productid, '_taxnow_taxcode', true );

			$item_freightcode = get_post_meta( $item_productid, '_taxnow_freightcode', true );



			if ( $item_taxcode != '' )

				$tax_code = $item_taxcode;

			else

				$tax_code = $global_tax_code;


			$items[] = array(

				'ItemCode' => $item_code,

				'Description' => $item_desc,

				'TaxCode' => $tax_code,

				'Qty' => $line_item['qty'],

				'Amount' => $line_item['line_subtotal'],
				'Discounted' => $discounted );

			}



		if (get_option('woocommerce_calc_shipping') == 'yes')

			{
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			$freight_code = $settings_array[ 'default_freight_code' ];

			$shipping = $woo_order->get_total_shipping();

			$items[] = array(

				'ItemCode' => 'Shipping',
				'Description' => 'Shipping (System generated line item)',

				'TaxCode' => $freight_code,

				'Qty' => 1,

				'Amount' => $shipping,
				'Discounted' => 0,

				'price' => $shipping	);

			}



		// commit transaction (based on transaction type), results will be logged

		if ($order_type == 'SalesInvoice' )

			$blnCommitResult = $this->commit_tax($doc_code, $customer_email, $address, $items, $discount_pretax, $exemption_id, $enable_exempt_id, $tx_type );

		elseif ($order_type== 'ReturnInvoice')

			$blnCommitResult = $this->commit_refund($doc_code, $customer_email, $address, $items, $order_id, $order_date, $discount_pretax, $exemption_id, $enable_exempt_id, $tx_type );

		else 

			$blnCommitResult = false;	// this should not happen



		if ( $blnCommitResult )

			{

			// add a note that order is committed to Avalara
			if ($order_type == 'ReturnInvoice') update_post_meta( $order_id, '_taxnow_avalaracommit', 'return');
			else update_post_meta( $order_id, '_taxnow_avalaracommit', 'sales');

			}



		else

			{

			// send notification

			$this->add_error_msg('Commit error on: '. $doc_code.'|'.$order_type);

			$err_array = $this->get_error_msgs();

			$err_string = implode("|", $err_array);

			$this->log_add_entry( 'Commit error', 'error', $err_array );

			wp_mail(

				get_option( 'admin_email' ),

				"Tax Commit Error ($doc_code)",

				$err_string );	

			}



	}



	// ------------------------------------------------	

	// determine is an order is filtered from Avalara processing

	private function is_order_state_filtered($order_id)

	{

		$woo_order = new WC_Order($order_id);



		if ($this->disable_tax_calc == 'yes')

			{

				return true;		// true = filter me

			}

		elseif ($this->tax_calc_filter_option == 'yes')
		
			{

			$shipping_state = $woo_order->shipping_state;

			$restrictions = (array)$this->tax_calc_filter_list;
			
			$key = array_search($shipping_state, $restrictions);

			if ($key === false)

				return true;		// true = filter me

			}

		return false;				// false = no filter so its a go

	}

	// ================================================
	public function handle_after_tax_discount()
	{
		global $woocommerce;
		if ($this->tax_discount == 'yes')
		{
			$this->discount_total = $woocommerce->cart->tax_total;
			return $woocommerce->cart->tax_total;
		}
		else
		{
			$this->discount_total = 0;
			return 0;
		}
	}

}



?>