<?php

if ( ! defined( 'ABSPATH' ) ) { 

    exit; // Exit if accessed directly

}



// ========================================

// class_taxnow_lineitem

// ========================================

class WC_Avalara_Lineitem

{

    private $_item_code;

    private $_item_name;

    private $_description;

    private $_tax_code;

    private $_quantity = 1;

    private $_unit_price;

    private $_tax_rate;

    private $_tax_amount;

    private $_tax_details;

    private $_discounted;

    private $_line_item_key;



    public function set_item_code( $item_code )

    {

        $this->_item_code = $item_code;

    }

    public function get_item_code()

    {

        return (string) $this->_item_code;

    }



    public function set_item_name( $item_name )

    {

        $this->_item_name = $item_name;

    }

    public function get_item_name()

    {

        return (string) $this->_item_name;

    }



    public function set_description( $description )

    {

        $this->_description = $description;

    }

    public function get_description()

    {

        return (string) $this->_description;

    }



    public function set_tax_code( $tax_code )

    {

        $this->_tax_code = $tax_code;

    }

    public function get_tax_code()

    {

        return (string) $this->_tax_code;

    }



    public function set_quantity( $quantity )

    {

        if( $quantity <= 0 )

        {

            wp_die( "TaxNOW: quantity should not be negative or 0" );

        }

        $this->_quantity = $quantity;

    }

    public function get_quantity()

    {

        return (float) $this->_quantity;

    }



    public function set_unit_price( $unit_price )

    {

        $this->_unit_price = round( $unit_price, 2 );

    }

    public function get_unit_price()

    {

        return (float) $this->_unit_price;

    }



    public function set_discounted( $discounted )

    {

        $this->_discounted = $discounted;

    }

    public function get_discounted()

    {

        return (string) $this->_discounted;

    }



    public function set_item_key( $item_key )

    {

        $this->_line_item_key = $item_key;

    }

    public function get_item_key()

    {

        return (string) $this->_line_item_key;

    }



    /**

    * @returns decimal Amount, tax exclusive

    */

    public function get_amount_excl()

    {

        return round( $this->get_unit_price(), 2);  // Removed "* $this->get_quantity()" because calling functions are sending the line subtotal instead of unit price

    }



    /**

    * @returns decimal Amount, tax inclusive

    */

    public function get_amount_incl()

    {

        return $this->get_amount_excl() + $this->get_tax_amount();

    }



    // ========================================

    // set_tax

    // ========================================

    public function set_tax( $tax_rate, $tax_amount, array $details )

    {

        $this->_tax_rate = round( $tax_rate, 6 );

        $this->_tax_amount = round( $tax_amount, 2 );

        if( is_array( $details ) )

        {

            foreach( $details as $detail )

            {

                if( !( $detail instanceof WC_Avalara_Tax_Details ) )

                {

                    wp_die(

                        'TaxNOW.set_tax: Details should be array of ' .

                        'WC_Avalara_Tax_Details instances. ' .

                        'Instead found: ' . print_r( $detail, 1 )

                    );

                }

            }

        }

        $this->_tax_details = $details;



    } // set_tax()



    public function get_tax_rate()

    {

        return (float) $this->_tax_rate;

    }

    public function get_tax_amount()

    {

        return (float) $this->_tax_amount;

    }

    public function get_tax_details()

    {

        return (array) $this->_tax_details;

    }



} // WC_Avalara_Lineitem



?>