<?php

if ( ! defined( 'ABSPATH' ) ) { 

    exit; // Exit if accessed directly

}



// ========================================

// class_taxnow_woo_data

// 	Used to store data in $_SESSION

//	Will be deprecated in the future so dont rely on it

// ========================================

class WC_Avalara_Data

{

    private $_login_form;



    // ========================================

    public function __construct()

    {

        // ----------------------------------------

        // Make sure $_SESSION contains all necessary TaxNow properties

        // ----------------------------------------

        $properties = array(

            'active_login_form' => null,

            'taxed_lines' => null,

            'validated_woo_address' => null,

            'validated_avalara_address' => null,

            'cart' => null,

            'completed_steps' => null,

			'woo_shipping' => null

        );

		

		if( !isset( $_SESSION[ 'TaxNOW' ] ) )

            $_SESSION['TaxNOW'] = array();		// set it up if it doesn't exist



		// capture newer data (may still be the same, but need to check, some is WC data)

		$_SESSION[ 'TaxNOW' ] = array_merge(

            $properties, array_intersect_key( (array) $_SESSION[ 'TaxNOW' ], $properties )

        );

		

    } // __construct()



    // ========================================

    // return true when successful, false when not

    public function set_active_login_form( $form_name )

    {

        $forms = array( TN_WOO_FORM_LOGGED, TN_WOO_FORM_LOGIN, TN_WOO_FORM_REGISTER );

        if( !in_array( $form_name, $forms ) )

        {

			return false;

        }

        $_SESSION[ 'TaxNOW' ][ 'active_login_form' ] = $form_name;

		return true;



    } // set_active_login_form()



    // ========================================

    // get_active_login_form

    public function get_active_login_form()

    {

        if( !isset( $this->_login_form ) )

        {

            if( is_user_logged_in() )

            {

		$_SESSION[ 'TaxNOW' ][ 'active_login_form' ] = TN_WOO_FORM_LOGGED;

            }

            else

            {

                $forms = array( TN_WOO_FORM_LOGGED, TN_WOO_FORM_LOGIN, TN_WOO_FORM_REGISTER );

                if ( !in_array( $_SESSION[ 'TaxNOW' ][ 'active_login_form' ], $forms ) )

                {

                    $_SESSION[ 'TaxNOW' ][ 'active_login_form' ] = TN_WOO_FORM_LOGIN;

                }

            }



            $this->_login_form = $_SESSION[ 'TaxNOW' ][ 'active_login_form' ];

        }



        return $this->_login_form;



    } // get_active_login_form()



    // ========================================

    // clear_tax_data

    public function clear_tax_data()

    {

        $_SESSION[ 'TaxNOW' ][ 'taxed_lines' ] = null;

    } // clear_tax_data()



    // ========================================

    // set_tax_data

    // ========================================

    public function set_tax_data( array $items )

    {

        $_SESSION[ 'TaxNOW' ][ 'taxed_lines' ] = $items;



    } // set_tax_data()



    // ========================================

    // is_tax_calculated

    // ========================================

    public function is_tax_calculated()

    {

        return isset( $_SESSION[ 'TaxNOW' ][ 'taxed_lines' ] );



    } // is_tax_calculated()



    // ========================================

    // get_tax_lines

    // ========================================

    /**

    * @returns array

    */

    public function get_tax_lines()

    {

        return (array) $_SESSION[ 'TaxNOW' ][ 'taxed_lines' ];



    } // get_tax_lines()



    // ========================================

    // get_validated_woo_address

    // ========================================

    public function get_validated_woo_address()

    {

        return (array) $_SESSION[ 'TaxNOW' ][ 'validated_woo_address' ];



    } // get_validated_woo_address()



    // ========================================

    // get_validated_avalara_address

    // ========================================

    public function get_validated_avalara_address()

    {

        return (array) $_SESSION[ 'TaxNOW' ][ 'validated_avalara_address' ];



    } // get_validated_avalara_address()



} // WC_Avalara_Data



?>