<?php

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}


// base class -- does not get called directly, it will be extended



abstract class WC_Avalara_Base

{



	public $config_warning_stack = array();

	public $error_stack = array();

	public $frontend_msg_stack = array();

	public $debug_stack = array();

	private $loginsertid;

	private $timer_start;

	private $timer_end;

	private $timer_total;

	

	// =================================================

    public function __construct()

	{

		if ( is_admin() )

			$this->install();


		// load TaxNOW after ecomm plugin is initialized and loaded

		add_action( $this->init_event, array( $this, 'init' ), 10 );

	}



	// =================================================

	public function install()

	{

		$file = dirname(__FILE__) . '/woocommerce-avalara.php';	// main file is not this file

		register_activation_hook( $file, array( $this, 'do_taxnow_activate' ) );

		register_deactivation_hook( $file, array( $this, 'do_taxnow_deactivate' ) );

		//register_uninstall_hook( $file, array( $this, 'do_taxnow_uninstall' ) );  // saved for later when we actually have an uninstaller

	}



	// =================================================	

	public function validate_ecomm_plugin()

	{



		// if ecomm plugin isn't here, TaxNOW cannot be here

		if( !class_exists($this->ecomm_class) )

			{

			deactivate_plugins(plugin_basename(dirname(__FILE__) . '/woocommerce-avalara.php')); // Deactivate ourselves

			$message = '<div style="font-family:sans-serif;font-size:12px;line-height:1.4em; margin:0; padding:0;">Cannot activate TaxNOW plugin: You must install and/or activate "' . $ecomm_name . '" plugin first before you can activate TaxNOW.</div>';

			die ($message);		// this runs in a IFRAME, WP does not handle this much better

			}



		return true;

	}



	// =================================================

	public function scan_configuration_taxnow()

	{

		// look for config issues that may cause the checkout system to not work

		//		this is also used by admin class



		$op = $this->tn_option_prefix;	// simplify


		$settings_array = get_option( 'woocommerce_avatax_settings' );
		if ( $settings_array[ 'disable_tax_calc' ] == 'no' || $settings_array[ 'disable_addr_validation' ] == 'no' )

			{

			// we are set to do tax and addr validation, make sure other settings are in place		

			if ( !isset( $settings_array[ 'account' ] ) || 

					!isset( $settings_array[ 'license' ] ) || 

					!isset( $settings_array[ 'avalara_url' ] ) || 

					!isset( $settings_array[ 'company_code' ] ) )

				{

				$this->add_config_warning('Warning: TaxNOW Credentials are not set or not valid.');

				}

			// and let's check the origin address

			if ( 	!isset( $settings_array[ 'origin_city' ] ) ||

					!isset( $settings_array[ 'origin_state' ] ) ||

					!isset( $settings_array[ 'origin_street' ] ) ||

					!isset( $settings_array[ 'origin_zip' ] ) )

				{

				$this->add_config_warning('Warning: TaxNOW "Origin Address" is not set.');

				}


			// and let's check for Origin Country now that we're global...
			if ( 	!isset( $settings_array[ 'origin_country' ] ) )

				{

				$this->add_config_warning('Warning: TaxNOW "Country" is not set in the Origin Address.');

				}


			// and let's check for a Default Freight Code

			if (	!isset( $settings_array[ 'company_code' ] ) )

				{

				$this->add_config_warning('Warning: TaxNOW "Default Freight Code" is not set. (The default is what you have set under your Avalara Control Panel.)');

				}



			// and let's check for a Default Tax Code

			if ( 	!isset( $settings_array[ 'default_tax_code' ] ) )

				{

				$this->add_config_warning('Warning: TaxNOW "Default Tax Code" is not set. (The default is what you have set under your Avalara Control Panel.)');

				}

			}



		if ($this->main_template_file=='0')		// '0' is return code when file is not found

			{

			$this->add_config_warning('Warning: TaxNOW cannot find template file');

			}

	}



	// =================================================

	public function validate_address( array $address )

	{



		// @returns ValidAddress Object or FALSE in case of error

		$valid_address = false;

		

		$service = $this->create_service('AddressServiceSoap');



		$request = new ValidateRequest();



		// ----------------------------------------

		// Destination address

		// ----------------------------------------

		$addr_blank = array(

			'Line1' => '',

			'City' => '',

			'Region' => '',

			'PostalCode' => '',
			'Country' => ''

		);

		$address = array_merge(

			$addr_blank, array_intersect_key( $address, $addr_blank )

		);

		$destination = new Address();

			$destination->setLine1( $address[ 'Line1' ] );

			$destination->setCity( $address[ 'City' ] );

			$destination->setRegion( $address[ 'Region' ] );

			$destination->setPostalCode( $address[ 'PostalCode' ] );
			$destination->setCountry( $address[ 'Country' ] );

		$request->setAddress($destination);

		$request->setTaxability(true);



		$this->log_add_entry( 'validate_address','request', $request );

		$response = $service->validate( $request );

		$this->log_add_entry( 'validate_address','response', $response );



		if( $response->getResultCode() == SeverityLevel::$Success )

		{

			$valid_address = $response->getValidAddresses();

			$valid_address = $valid_address[0];

//			$valid_address->setPostalCode( substr( $valid_address->GetPostalCode(), 0, 5 ) );	// uncomment to force 5-digit zip/postal codes

		}

		

		else	// no success

		{

			$this->add_service_msgs($response->getMessages());

			$valid_address = NULL;		// added this to make sure value is defined

		}

		

		return $valid_address;

	

	} // validate_address()





	// =================================================

	public function calc_tax( $customer, array $address, array $items, $discount_pretax, $exemption_id, $enable_exempt_id )

	{

		$this->timer_start = microtime(true);

		$result = false;

		

		$service = $this->create_service( 'TaxServiceSoap' );

		$request = new GetTaxRequest();


		$docCode = ''; // We don't use the order number on transient tax calls
		

		// ----------------------------------------

		// Origin address

		// ----------------------------------------

		$op = $this->tn_option_prefix;

		$origin = new Address();
		
			$settings_array = get_option( 'woocommerce_avatax_settings');
			$origin->setLine1( $settings_array[ 'origin_street' ] );
			$origin->setCity( $settings_array[ 'origin_city' ] );
			$origin->setRegion( $settings_array[ 'origin_state' ] );
			$origin->setPostalCode( $settings_array[ 'origin_zip' ] );
			$origin->setCountry( $settings_array[ 'origin_country' ] );

		$request->setOriginAddress($origin);

		

		// ----------------------------------------

		// Destination address

		// ----------------------------------------

		$addr_blank = array(

			'Line1' => '',

			'City' => '',

			'Region' => '',

			'PostalCode' => '',

			'Country' => ''
		);

		$address = array_merge(

			$addr_blank, array_intersect_key( $address, $addr_blank )

		);

		$destination=  new Address();

			$destination->setLine1( $address[ 'Line1' ] );

			$destination->setCity( $address[ 'City' ] );

			$destination->setRegion( $address[ 'Region' ] );

			$destination->setPostalCode( $address[ 'PostalCode' ] );
			$destination->setCountry( $address[ 'Country' ] );

		$request->setDestinationAddress($destination);

		

		// ----------------------------------------

		// Create lines of document

		// ----------------------------------------

		$corr_keys = array();

		$lines = array();

		foreach( $items as $key => $item )

		{

			if( !( $item instanceof WC_Avalara_Lineitem ) )

			{

				wp_die(

					'TaxNOW.calc_tax: Line should be instance of WC_Avalara_Lineitem. ' .

					'Instead found: ' . print_r( $item, 1 )

				);

			}

		

			// ----------------------------------------

			// Create line

			// ----------------------------------------

			$i = count( $lines );

			$lines[ $i ] = new Line();

			$lines[ $i ]->setItemCode( substr( $item->get_item_code(), 0, 50 ) );

			$lines[ $i ]->setDescription( substr( $item->get_description(), 0, 255 ) );

			$lines[ $i ]->setTaxCode( $item->get_tax_code() );

			$lines[ $i ]->setQty( $item->get_quantity() );

			$lines[ $i ]->setAmount( $item->get_amount_excl() );

			$lines[ $i ]->setNo ( $i+1 );
			$lines[ $i ]->setDiscounted ( $item->get_discounted() );

			$corr_keys[ $i+1 ] = $key;

		}

		

		$request->setLines( $lines );

		$request->setDocDate( date( 'Y-m-d', current_time( 'timestamp' ) ) );

		$request->setDocCode( $docCode );

		$request->setCustomerCode( $customer );
		
		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$request->setCompanyCode( $settings_array[ 'company_code' ] );

		$request->setDocType( DocumentType::$SalesOrder );

		$request->setDetailLevel( DetailLevel::$Tax );
		$request->setCurrencyCode( get_option('woocommerce_currency') );

		//$request->setBusinessIdentificationNo( $settings_array[ 'business_vat_id' ] ); // removed since AvaTax needs buyers VAT not sellers

		if ($enable_exempt_id == 'e')
			$request->setExemptionNo( $exemption_id );
		else if ($enable_exempt_id == 'b')
			$request->setBusinessIdentificationNo( $exemption_id );

		if ($discount_pretax && $discount_pretax > 0) $request->setDiscount( $discount_pretax );

		

		// ----------------------------------------

		// Get tax

		// ----------------------------------------

		$this->log_add_entry( 'calculate_tax','request', $request );

		$response = $service->getTax( $request );

		$this->log_add_entry( 'calculate_tax','response', $response );

		

		if( $response->getResultCode() == SeverityLevel::$Success )

		{

			foreach( $response->GetTaxLines() as $TaxLine )

			{

				$tax_details = array();

				foreach( $TaxLine->getTaxDetails() as $TaxDetail )

				{

					$lineitem_taxdetail = new WC_Avalara_Tax_Details();

					$lineitem_taxdetail->set_tax_name( $TaxDetail->getTaxName() );

					$lineitem_taxdetail->set_tax_rate( $TaxDetail->getRate() );

					$lineitem_taxdetail->set_juris_name( $TaxDetail->getJurisName() );

					$lineitem_taxdetail->set_juris_type( $TaxDetail->getJurisType() );

					$lineitem_taxdetail->set_region( $TaxDetail->getRegion() );

					$lineitem_taxdetail->set_taxable( $TaxDetail->getTaxable() );

					$tax_details[] = $lineitem_taxdetail;

				}

				$items[ $corr_keys[ $TaxLine->GetNo() ] ]->set_tax(

					$TaxLine->GetRate(), $TaxLine->GetTax(), $tax_details

				);

			}

		

			$result = true;

		}

		

		else		// no success

		{

			$this->add_service_msgs($response->getMessages());

			$result = false;

		}



		$this->timer_end = microtime(true);

		$this->timer_total = $this->timer_end - $this->timer_start;

		return $result;

	} // calc_tax()



	// =================================================

	// added support to void transactions | Aug 2012

    public function cancel_request( $doc_code )

    {
		$result = false;

		

		$service = $this->create_service('TaxServiceSoap');

		

		$request = new CancelTaxRequest();
		
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			$request->setDocCode($doc_code);

			$request->setDocType('SalesInvoice');

			$request->setCompanyCode( $settings_array[ 'company_code' ] );

			$request->setCancelCode('DocVoided');

		$this->log_add_entry( 'cancel_tax','request', $request );

		try

		{	$response = $service->CancelTax( $request );	}

		catch ( Exception $e )

		{

			$response = null;

			$this->add_error_msg($e->getMessage());

		}

		$this->log_add_entry( 'cancel_tax','response', $response );



		if( isset( $response ) )

		{

			if( $response->getResultCode() == SeverityLevel::$Success )

				$result = true;

			else

				$this->add_service_msgs($response->getMessages());

		}

		

		return $result;

	}



	// =================================================

	public function commit_tax( $doc_code, $customer, array $address, array $items, $discount_pretax, $exemption_id, $enable_exempt_id )

    {

		$result = false;

		

		$service = $this->create_service('TaxServiceSoap');

		

		$request = new GetTaxRequest();

		

		// ----------------------------------------

		// Origin address

		// ----------------------------------------

		$op = $this->tn_option_prefix;

		$origin = new Address();
		
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			$origin->setLine1( $settings_array[ 'origin_street' ] );

			$origin->setCity( $settings_array[ 'origin_city' ] );

			$origin->setRegion( $settings_array[ 'origin_state' ] );

			$origin->setPostalCode( $settings_array[ 'origin_zip' ] );
			$origin->setCountry( $settings_array[ 'origin_country' ] );

		$request->setOriginAddress($origin);

		

		// ----------------------------------------

		// Destination address

		// ----------------------------------------

		$addr_blank = array(

			'Line1' => '',

			'City' => '',

			'Region' => '',

			'PostalCode' => '',
			'Country' => ''

		);

		$address = array_merge(

			$addr_blank, array_intersect_key( $address, $addr_blank )

		);

		$destination = new Address();

			$destination->setLine1( $address[ 'Line1' ] );

			$destination->setCity( $address[ 'City' ] );

			$destination->setRegion( $address[ 'Region' ] );

			$destination->setPostalCode( $address[ 'PostalCode' ] );
			$destination->setCountry( $address[ 'Country' ] );

		$request->setDestinationAddress($destination);

		

		// ----------------------------------------

		// Create lines of document

		// ----------------------------------------

		$lines = array();

		$item_blank = array(

			'ItemCode' => '',

			'Description' => '',

			'TaxCode' => '',

			'Qty' => 1,

			'Amount' => 0,
			'Discounted' => 0,

		);



		foreach( $items as $item )

		{

			// ----------------------------------------

			// Normalize item structure

			// ----------------------------------------

			$item = array_merge(

				$item_blank, array_intersect_key( $item, $item_blank )

			);

		

			// ----------------------------------------

			// Create line

			// ----------------------------------------

			$i = count( $lines );

			$lines[ $i ] = new Line();

			$lines[ $i ]->setNo ( $i+1 );

			$lines[ $i ]->setItemCode( substr( $item[ 'ItemCode' ], 0, 50 ) );

			$lines[ $i ]->setDescription( substr( $item[ 'Description' ], 0, 255 ) );

			$lines[ $i ]->setTaxCode( $item[ 'TaxCode' ] );

			$lines[ $i ]->setQty( $item[ 'Qty' ] );

			$lines[ $i ]->setDiscounted ( $item[ 'Discounted' ] );

			// irrelevant for commit_tax function since it will be handled by commit_refund
//			if ($doc_type == 'ReturnInvoice')

//				$lines[ $i ]->setAmount( ($item[ 'Amount' ] * -1) );

//			else

				$lines[ $i ]->setAmount( $item[ 'Amount' ]);

		}


		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$request->setLines( $lines );

		$request->setDocDate( date( 'Y-m-d', current_time( 'timestamp' ) ) );

		$request->setDocCode( $doc_code );

		$request->setCustomerCode( $customer );

		$request->setReferenceCode(	$this->get_plugin_name() . ' v' . $this->get_version() );

		$request->setCompanyCode( $settings_array[ 'company_code' ] );

		$request->setDocType( DocumentType::$SalesInvoice);

		$request->setDetailLevel( DetailLevel::$Line );

		$request->setCommit( true );    // Makes transaction committed at once
		$request->setCurrencyCode( get_option('woocommerce_currency') );

		//$request->setBusinessIdentificationNo( $settings_array[ 'business_vat_id' ] ); // removed since AvaTax needs buyers VAT not sellers

		if ($enable_exempt_id == 'e')
			$request->setExemptionNo( $exemption_id );
		else if ($enable_exempt_id == 'b')
			$request->setBusinessIdentificationNo( $exemption_id );

		if ($discount_pretax && $discount_pretax > 0) $request->setDiscount( $discount_pretax );

		

		// ----------------------------------------

		// Commit tax

		// ----------------------------------------

		$this->log_add_entry( 'commit_tax','request', $request, $doc_code ); // switched from purchase_log_id to doc_code

		try

		{

			$response = $service->getTax( $request );

		}

		catch ( Exception $e )

		{

			$response = null;

			$this->add_error_msg($e->getMessage());

		}

		$this->log_add_entry( 'commit_tax','response', $response, $doc_code ); // switched from purchase_log_id to doc_code

		

		if( isset( $response ) )

		{

			if( $response->getResultCode() == SeverityLevel::$Success )

				$result = true;

			else

				$this->add_service_msgs($response->getMessages());

		}

		

		return $result;

		

	} // commit_tax()



	// =================================================

    public function commit_refund( $doc_code, $customer, array $address, array $items, $order_id, $order_date, $discount_pretax, $exemption_id, $enable_exempt_id )

    {
		$result = false;

		

		$service = $this->create_service('TaxServiceSoap');

		

		$request = new GetTaxRequest();



		$override = new TaxOverride();

			$override->setTaxDate($order_date);

			$override->setTaxOverrideType('TaxDate');

			$override->setReason('Refund');

		$request->setTaxOverride($override);

		

		// ----------------------------------------

		// Origin address

		// ----------------------------------------

		$op = $this->tn_option_prefix;

		$origin = new Address();
		    
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			$origin->setLine1( $settings_array[ 'origin_street' ] );

			$origin->setCity( $settings_array[ 'origin_city' ] );

			$origin->setRegion( $settings_array[ 'origin_state' ] );

			$origin->setPostalCode( $settings_array[ 'origin_zip' ] );
			$origin->setCountry( $settings_array[ 'origin_country' ] );

		$request->setOriginAddress($origin);

		

		// ----------------------------------------

		// Destination address

		// ----------------------------------------

		$addr_blank = array(

			'Line1' => '',

			'City' => '',

			'Region' => '',

			'PostalCode' => '',
			'Country' => ''

		);

		$address = array_merge(

			$addr_blank, array_intersect_key( $address, $addr_blank )

		);

		$destination = new Address();

			$destination->setLine1( $address[ 'Line1' ] );

			$destination->setCity( $address[ 'City' ] );

			$destination->setRegion( $address[ 'Region' ] );

			$destination->setPostalCode( $address[ 'PostalCode' ] );
			$destination->setCountry( $address[ 'Country' ] );

		$request->setDestinationAddress($destination);

		

		// ----------------------------------------

		// Create lines of document

		// ----------------------------------------

		$lines = array();

		$item_blank = array(

			'ItemCode' => '',

			'Description' => '',

			'TaxCode' => '',

			'Qty' => 1,

			'Amount' => 0,
			'Discounted' => 0

		);



		foreach( $items as $item )

		{

			// ----------------------------------------

			// Normalize item structure

			// ----------------------------------------

			$item = array_merge(

				$item_blank, array_intersect_key( $item, $item_blank )

			);

		

			// ----------------------------------------

			// Create line

			// ----------------------------------------

			$i = count( $lines );

			$lines[ $i ] = new Line();

			$lines[ $i ]->setNo ( $i+1 );

			$lines[ $i ]->setItemCode( substr( $item[ 'ItemCode' ], 0, 50 ) );

			$lines[ $i ]->setDescription( substr( $item[ 'Description' ], 0, 255 ) );

			$lines[ $i ]->setTaxCode( $item[ 'TaxCode' ] );

			$lines[ $i ]->setQty( $item[ 'Qty' ] );

			$lines[ $i ]->setDiscounted ( $item[ 'Discounted' ] );

			$lines[ $i ]->setAmount( ($item[ 'Amount' ] * -1) );	// refund, so show negative number

		}

		
		$settings_array = get_option( 'woocommerce_avatax_settings' );
		$request->setLines( $lines );

		$request->setDocDate( date( 'Y-m-d', current_time( 'timestamp' ) ) );

		$request->setDocCode( $doc_code );

		$request->setCustomerCode( $customer );

		$request->setCompanyCode( $settings_array[ 'company_code' ] );

		$request->setReferenceCode(	$this->get_plugin_name() . ' v' . $this->get_version() );

		$request->setDocType( DocumentType::$ReturnInvoice );

		$request->setDetailLevel( DetailLevel::$Line );

		$request->setCommit( true );    // Makes transaction committed at once
		$request->setCurrencyCode( get_option('woocommerce_currency') );

		//$request->setBusinessIdentificationNo( $settings_array[ 'business_vat_id' ] ); // removed since AvaTax needs buyers VAT not sellers

		if ($enable_exempt_id == 'e')
			$request->setExemptionNo( $exemption_id );
		else if ($enable_exempt_id == 'b')
			$request->setBusinessIdentificationNo( $exemption_id );

		if ($discount_pretax && $discount_pretax > 0) $request->setDiscount( $discount_pretax * -1);

		

		// ----------------------------------------

		// Commit tax

		// ----------------------------------------

		$this->log_add_entry( 'refund_tax','request', $request );

		try

		{

			$response = $service->getTax( $request );

		}

		catch ( Exception $e )

		{

			$response = null;

			$this->add_error_msg($e->getMessage());

		}

		$this->log_add_entry( 'refund_tax','response', $response );

		

		if( isset( $response ) )

		{

			if( $response->getResultCode() == SeverityLevel::$Success )

				$result = true;

			else

				$this->add_service_msgs($response->getMessages());

		}

		

		return $result;

		

	} // commit_refund()



	// =================================================

	public function create_service( $class_name, $use_post = false )

	{



		// when we create a service, we need to include the SDK files

		require_once( dirname(__FILE__) . '/AvaTax4PHP/AvaTax.php' );

		

		$op = $this->tn_option_prefix;	// simplify

		$client = $this->get_plugin_name() . ' v' . $this->get_version();

		

		if (!$use_post)

			{
			
			$settings_array = get_option( 'woocommerce_avatax_settings' );
			$avalara_url		= $settings_array[ 'avalara_url' ];

			$avalara_account	= $settings_array[ 'account' ];

			$avalara_license	= $settings_array[ 'license' ];

			}

		else		// this happens on the admin screen

			{

			$avalara_url		= $_POST[ 'avalara_url' ];

			$avalara_account	= $_POST[ 'account' ];

			$avalara_license	= $_POST[ 'license' ];

			}

		

		// set configurations for AvaTax4PHP SDK

		$config = new ATConfig(

			'TaxNOW',

			array(

				'url'       => $avalara_url,

				'account'   => $avalara_account,

				'license'   => $avalara_license,

				'client'    => $client,

				'trace'     => true

			)

		);

	

		return new $class_name( 'TaxNOW' );

	

	} // create_service()





	// =================================================

    public function get_template_file_path()

    {

		$filename = $this->main_template_file;		// the default

		

		$theme_file = get_template_directory() . '/' . $filename;

		$plugin_file = dirname(__FILE__) . '/avatax-templates-front/' . $filename;



		// look in directory of current theme

		if( file_exists( $theme_file ) )

			return $theme_file;



		// look in directory of plugin

		elseif( file_exists( $plugin_file ) )

            return $plugin_file;

		

		else	// we have a problem and have no file to return

			return 0;



    } // get_template_file_path()





	// =================================================

	public function get_countries()

	{

		return array(

			'US' => 'United States',

			'CA' => 'Canada'

		);

	} // get_countries





	// =================================================

    public function get_states()

    {

		return array(

			'AL' => 'Alabama',

			'AK' => 'Alaska',

			'AZ' => 'Arizona',

			'AR' => 'Arkansas',

			'CA' => 'California',

			'CO' => 'Colorado',

			'CT' => 'Connecticut',

			'DC' => 'DC (Washington)',

			'DE' => 'Delaware',

			'FL' => 'Florida',

			'GA' => 'Georgia',

			'HI' => 'Hawaii',

			'ID' => 'Idaho',

			'IL' => 'Illinois',

			'IN' => 'Indiana',

			'IA' => 'Iowa',

			'KS' => 'Kansas',

			'KY' => 'Kentucky',

			'LA' => 'Louisiana',

			'ME' => 'Maine',

			'MD' => 'Maryland',

			'MA' => 'Massachusetts',

			'MI' => 'Michigan',

			'MN' => 'Minnesota',

			'MS' => 'Mississippi',

			'MO' => 'Missouri',

			'MT' => 'Montana',

			'NE' => 'Nebraska',

			'NV' => 'Nevada',

			'NH' => 'New Hampshire',

			'NJ' => 'New Jersey',

			'NM' => 'New Mexico',

			'NY' => 'New York',

			'NC' => 'North Carolina',

			'ND' => 'North Dakota',

			'OH' => 'Ohio',

			'OK' => 'Oklahoma',

			'OR' => 'Oregon',

			'PA' => 'Pennsylvania',

			'RI' => 'Rhode Island',

			'SC' => 'South Carolina',

			'SD' => 'South Dakota',

			'TN' => 'Tennessee',

			'TX' => 'Texas',

			'UT' => 'Utah',

			'VT' => 'Vermont',

			'VA' => 'Virginia',

			'WA' => 'Washington',

			'WV' => 'West Virginia',

			'WI' => 'Wisconsin',

			'WY' => 'Wyoming',

		

			'AB' => 'Alberta',

			'BC' => 'British Columbia',

			'MB' => 'Manitoba',

			'NB' => 'New Brunswick',

			'NL' => 'Newfoundland and Labrador',

			'NT' => 'Northwest Territories',

			'NS' => 'Nova Scotia',

			'NU' => 'Nunavut',

			'ON' => 'Ontario',

			'PE' => 'Prince Edward Island',

			'QC' => 'Quebec',

			'SK' => 'Saskatchewan',

			'YT' => 'Yukon'

		);

    } // get_states()





	// =================================================

	public function get_log_table_name()

	{

		global $wpdb;

		return $wpdb->prefix . $this->tn_option_prefix . 'log2';

	} // get_log_table_name()





	// ========================================

	public function get_version()

	{

		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

		$plugin_data = get_plugin_data(dirname(__FILE__).'/woocommerce-avalara.php');

		$version = isset( $plugin_data[ 'Version' ] ) ? $plugin_data[ 'Version' ] : false;

		return $version;

	} // get_version





	// ========================================

	public function get_plugin_name()

	{

		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

		$plugin_data = get_plugin_data( dirname(__FILE__) . '/woocommerce-avalara.php' );

		$plugin_name = isset( $plugin_data[ 'Version' ] ) ?

			$plugin_data[ 'Name' ] : false;



		return $plugin_name;

	} // get_plugin_name

	



	// =================================================

    public function get_error_msgs()

    {



		// eliminates duplicate messages
		// Removed the below array code due to too many issues with various PHP implementations - JMA 2013-08-07
		// $current_stack = array_merge(array_flip(array_flip( (array) $this->error_stack ))); // replaced array_unique with flip-flip method. JMA 2013-06-27
		// so this is how we do it today:
		$current_stack = $this->error_stack;


		// prepare returnable string

		$new_stack = array();

		foreach ($current_stack as $item)

			{

			if (is_object($item))

				array_push($new_stack, serialize($item));

			elseif (is_array($item))

				array_push($new_stack, implode("|", $item));

			else

				array_push($new_stack, $item);

			}



		return $new_stack;

    } // get_error_msgs()





	// =================================================

    private function _handle_login()

    {

        $user = wp_signon(

            array(

                'user_login' => $_POST[ 'user_login' ],

                'user_password' => $_POST[ 'user_password' ],

                'remember' => isset( $_POST[ 'remember' ] )

            )

        );

        if ( is_wp_error( $user ) )

        {

			$this->add_frontend_msg( $user->get_error_message() );

            return false;

        }



        return true;



    } // _handle_login()





	// =================================================

    private function _handle_registration()

    {

        $user_login = $_POST[ 'user_login' ];

        $user_password = $_POST[ 'user_password' ];

        $user_email = $_POST[ 'email' ];



        require_once(ABSPATH . WPINC . '/registration.php');

        $errors = new WP_Error();

        $user_login = sanitize_user( $user_login );

        $user_email = apply_filters( 'user_registration_email', $user_email );



        // Check the username

        if ( $user_login == '' ) {

            $errors->add( 'empty_username', __( '<strong>ERROR</strong>: Please enter a username.' ) );

        } elseif ( !validate_username( $user_login ) ) {

            $errors->add( 'invalid_username', __( '<strong>ERROR</strong>: This username is invalid.  Please enter a valid username.' ) );

            $user_login = '';

        } elseif ( username_exists( $user_login ) ) {

            $errors->add( 'username_exists', __( '<strong>ERROR</strong>: This username is already registered, please choose another one.' ) );

        }



        // Check the e-mail address

        if ( $user_email == '' ) {

            $errors->add( 'empty_email', __( '<strong>ERROR</strong>: Please type your e-mail address.' ) );

        } elseif ( !is_email( $user_email ) ) {

            $errors->add( 'invalid_email', __( '<strong>ERROR</strong>: The email address isn&#8217;t correct.' ) );

            $user_email = '';

        } elseif ( email_exists( $user_email ) ) {

            $errors->add( 'email_exists', __( '<strong>ERROR</strong>: This email is already registered, please choose another one.' ) );

        }



        // ----------------------------------------

        // Create user

        // ----------------------------------------

        if ( !$errors->get_error_code() )

        {

            $user_id = wp_create_user( $user_login, $user_password, $user_email );

            if ( !$user_id ) {

                $errors->add( 'registerfail', sprintf( __( '<strong>ERROR</strong>: Couldn&#8217;t register you... please contact the <a href="mailto:%s">webmaster</a> !' ), get_option( 'admin_email' ) ) );

            }

            else

            {

                $credentials = array( 'user_login' => $user_login, 'user_password' => $user_password, 'remember' => true );

                $user = wp_signon( $credentials );

            }

        }



        // ----------------------------------------

        // Report errors

        // ----------------------------------------

        if ( $errors->get_error_code() )

        {

            foreach ( $errors->get_error_codes() as $code )

            {

                foreach ( $errors->get_error_messages( $code ) as $error )

                {

                    //$this->_add_front_message( $error );

					$this->add_frontend_msg($error);

                }

            }

            return false;

        }



        return true;



    } // _handle_registration()





	// =================================================

	public function log_add_entry( $type, $action, $msg, $purchase_log_id = -99 )

	{

//		global $wpdb;

		$ip = $_SERVER['REMOTE_ADDR'];



		// need to convert for db storage

		if ( is_array( $msg ) || is_object( $msg ) )

			$msg = print_r( $msg, 1 );

		

			$logfile_handle = fopen( TN_WOO_FILE_PATH . '/wc-avalara-tx-log.txt', 'a');

			fwrite( $logfile_handle, "=================================================================================\r\n\r\n" );
			fwrite( $logfile_handle, 'Type: ' . $type . "\r\n" );
			fwrite( $logfile_handle, 'Purchase ID: ' . $purchase_log_id . "\r\n" );
			fwrite( $logfile_handle, 'Action: ' . $action . "\r\n" );
			fwrite( $logfile_handle, 'Message: ' . $msg . "\r\n" );
			fwrite( $logfile_handle, 'User IP: ' . $ip . "\r\n\r\n" );
			
			fclose($logfile_handle);
			

	} // log_add_entry()





	// =================================================

	public function add_config_warning($in_warning)

	{

		array_push($this->config_warning_stack,$in_warning);

	}





	// =================================================

	public function add_error_msg($in_err)

	{

		array_push($this->error_stack,$in_err);

	}





	// =================================================

	public function add_service_msgs( $service_msg )

	{

		// service_msgs is an array of messages sent back from Avalara
		// this function is called when we do not get a Sucsess message from service

		foreach( $service_msg as $msg_detail )

			array_push($this->error_stack,$msg_detail);

	} // add_service_msgs



	// =================================================

	public function add_frontend_msg($in_msg)

	{

		array_push($this->frontend_msg_stack,$in_msg);

	}



	// =================================================

	public function add_debug_msg($in_msg)

	{

		array_push($this->debug_stack,$in_msg);

	}



} // WC_Avalara_Base

?>