<?php

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly
}


class WC_Avalara_Admin

{

	private $AvaTaxFile;		// name of main SDK file

	private $AvaTaxExists;		// if this file exists

    public function __construct()

	{

		// this class loads during main taxnow init (admin folks only), so WC is already running

		$this->init();

	}


	// ============================================================

	function init()

		{



		// ajax actions

		add_action( 'wp_ajax_taxnow_test_connection', array( $this, 'handle_post_test_avalara_connection' ) );

		add_action( 'wp_ajax_taxnow_validate_origin', array( $this, 'handle_post_validate_address_origin' ) );

		add_action( 'wp_ajax_taxnow_general_save', array( $this, 'handle_post_save_admin_settings' ) );



		// new version checker with wp plugin_update hook

		add_filter('pre_set_site_transient_update_plugins', 'check_for_plugin_update');

		function check_for_plugin_update ($transient) {

			$installedVersion = TN_WOO_VERSION;

			$checkfile = "http://www.adipietro.com/current_version_tnwoo.txt";

			$vcheck = wp_remote_fopen($checkfile);

			if( $vcheck ) {

				$status = explode('@', $vcheck);

				$latestVersion = $status[1];

			}

			else $latestVersion = '1.0error';

			if (version_compare(strval($latestVersion), strval($installedVersion), '>') == 1) {

				$obj = new stdClass();  

				$obj->name = 'AvaTax Integration for WooCommerce';

				$obj->slug = 'taxnow_woo';

				$obj->new_version = $latestVersion;  

				$obj->url = 'http://www.adipietro.com/shop';  

				$obj->package = 'http://www.adipietro.com/taxnow_woo_current.zip';  

				$transient->response['woocommerce-avalara/woocommerce-avalara.php'] = $obj;  

			}



			return $transient;

		}



		// override plugin info via plugin_api hook, since plugin is not hosted by wordpress.org

		add_filter ('plugins_api_result', 'plugin_api_call', 10, 3);

		function plugin_api_call($def, $action, $args) {



			// only override plugin info for taxnow

			$plugin_slug = 'taxnow_woo';


			if (!is_object($args))
			{
				$arg_request = unserialize($args['body']['request']);
				$update_slug = $arg_request->slug;
			}
			else
				$update_slug = $args->slug;

			if ($update_slug != $plugin_slug)
				return $def;


			// define the plugin info page which will load in an iframe

			$pinfo = new stdClass();

			$pinfo->name = 'AvaTax Integration for WooCommerce';

			$pinfo->slug = 'taxnow_woo';



			$checkfile = "http://www.adipietro.com/current_version_tnwoo.txt";

			$vcheck = wp_remote_fopen($checkfile);

			if( $vcheck ) {

				$status = explode('@', $vcheck);

				$latestVersion = $status[1];

			}

			else $latestVersion = '1.0error';

			$pinfo->version = $latestVersion;



			$pinfo->author = 'Adipietro Technology Services';

			$pinfo->requires = '3.5';

			$pinfo->tested = '3.8';

			$pinfo->last_updated = '2014-02-10';

			$pinfo->homepage = 'http://www.adipietro.com';



			$changelogfile = wp_remote_fopen('http://www.adipietro.com/tn-woo-change-log.php');

			$pinfo->sections = array(

				'description' => "The AvaTax Integration extends your WooCommerce store to enable sales tax and address validation from Avalara's AvaTax service.",

				'changelog' => $changelogfile

			);

			$pinfo->download_link = 'http://www.adipietro.com/taxnow_woo_current.zip';



			return $pinfo;

		}


		// display product maintenance form fields

		add_action( 'woocommerce_product_write_panel_tabs', array( $this, 'product_write_taxnow_tab' ) );

		add_action( 'woocommerce_product_write_panels', array( $this, 'product_write_taxnow_panel' ) );



		// saving product meta data

		add_action( 'woocommerce_process_product_meta_simple', array( $this, 'process_product_meta_taxnow' ) );

		add_action( 'woocommerce_process_product_meta_variable', array( $this, 'process_product_meta_taxnow' ) );

		add_action( 'woocommerce_process_product_meta_grouped', array( $this, 'process_product_meta_taxnow' ) );

		

		// display order screen tax information | 2.0

		add_action( 'woocommerce_admin_order_totals_after_shipping', array ($this, 'orderdetails_writepanel_taxamounts') );



		// check if SDK is installed

		$this->AvaTaxFile = TN_WOO_FILE_PATH . '/AvaTax4PHP/AvaTax.php';

		if (file_exists($this->AvaTaxFile))

			$this->AvaTaxExists = true;

		else

			$this->AvaTaxExists = false;



		// checks for various admin messages and creates an action to display

		$this->init_show_admin_warnings();


	} // init()



	// ============================================================

	public function init_show_admin_warnings()

	{



		global $avatax_main;

	

		$warnings = sizeof($avatax_main->config_warning_stack);

		if ( $warnings > 0 )

		{

		

			function taxnow_woo_warning_message()

			{

				global $avatax_main;

				

				echo "<br><div id='tn-warning' class='updated fade'><p><strong>TaxNOW has configuration issues that must be resolved before it can be used:";

				foreach ($avatax_main->config_warning_stack as $msg)

				{

					echo '<br>&nbsp;&nbsp;&nbsp;'.$msg;

				}

				echo '<br/><br/>Please double check your <a href="admin.php?page=show_taxnow_settings">TaxNOW Settings</a> and <a href="admin.php?page=woocommerce_settings&tab=tax">WooCommerce settings</a>.</p></div>';

			}

			

			add_action('admin_notices', 'taxnow_woo_warning_message', 30);

		}



	}


	// ============================================================
	// called from integration class. will eventually be moved to that class.
	
    public function handle_post_test_avalara_connection()

    {

		if (!$this->AvaTaxExists)

			{

			$msg = 'Error: AvaTax SDK is not installed';

			echo $msg;

			return;

			}



        // ----------------------------------------

        // Create object with test connection data

        // ----------------------------------------

        require_once( TN_WOO_FILE_PATH . '/AvaTax4PHP/AvaTax.php' );

        

		global $avatax_main;



		// set configurations for AvaTax4PHP SDK

		$config = new ATConfig(

            'TNWOO',

            array(

                'url'       => $_POST[ 'avalara_url' ],

                'account'   => $_POST[ 'account' ],

                'license'   => $_POST[ 'license' ],

				'client'	=> 'TaxNOW for WP/WOO v'.$avatax_main->get_version(),

                'trace'     => true

            )

        );

		$service = new TaxServiceSoap( 'TNWOO' );



        // ----------------------------------------

        // Get tax

        // ----------------------------------------

        try

        {

            $res = $service->ping();

        }

        catch ( Exception $e )

        {

			$msg = $e->getMessage();

        }



        if( isset( $res ) )

        {

            if( $res->getResultCode() == SeverityLevel::$Success )

            {

				$msg = 'Success! Your account information is confirmed.';

				

				foreach( $_POST as $option_name => $value )

				{
					$settings_array = get_option( 'woocommerce_avatax_settings');

					if ( $option_name!= 'action' && $value != $settings_array[$option_name] )

						{
						$settings_array[$option_name] = $value;
						update_option( 'woocommerce_avatax_settings', $settings_array );

						}

				}



            }

            else

            {

				$msg = $res->getMessages();

            }

        }



		echo $msg;		// html response on this one

        die();



    } // ------- handle_post_test_avalara_connection



	// ============================================================
	// called from integration class. will eventually be moved to that class.
	
    public function handle_post_validate_address_origin()

    {



		if (!$this->AvaTaxExists)

			{

			$response['Status'] ='0';

			$response[ 'Message' ] = 'Error: Cannot validate address, the AvaTax SDK is not installed.';



			// --- It's AJAX query that expects JSON in response

			header( "Content-Type: text/x-json; charset: UTF-8" );

			header( "Cache-Control: no-store, no-cache, must-revalidate" );

			echo json_encode( $response );

			exit;

			}



		try

		{

			global $avatax_main;

			$service = $avatax_main->create_service( 'AddressServiceSoap' );



			$request = new ValidateRequest();



			// ----------------------------------------

			// Destination address

			// ----------------------------------------

			$origin = new Address();

				$origin->setLine1( $_POST[ 'origin_street' ] );

				$origin->setCity( $_POST[ 'origin_city' ] );

				$origin->setRegion( $_POST[ 'origin_state' ] );

				$origin->setPostalCode( $_POST[ 'origin_zip' ] );
				$origin->setCountry( $_POST[ 'origin_country' ] );

			$request->setAddress($origin);

			$request->setTaxability(true);

			$avatax_main->log_add_entry( 'validate_address_origin','request', $request );

			$result = $service->validate( $request );

			$avatax_main->log_add_entry( 'validate_address_origin','response', $result );



			if( $result->getResultCode() == SeverityLevel::$Success )

			{

				$valid_address = $result->getValidAddresses();

				$valid_address = $valid_address[0];



				$response = array();

					$response['Status'] ='1';

					$response['Message'] ='Validated!';

					$response['Line1'] = $valid_address->GetLine1();

					$response['City'] = $valid_address->GetCity();

					$response['Region'] = $valid_address->getRegion();

					$response['PostalCode'] = $valid_address->GetPostalCode();
					$response['Country'] = $valid_address->GetCountry();



				// save the data!

				$post = $_POST;



				// always, always use the zip+4 by default

				$post['taxnow_origin_zip'] = $response['PostalCode'];

				foreach( $post as $option_name => $value )

				{

					//echo '<br>'.$option_name.'=>'.$value;

					$settings_array = get_option( 'woocommerce_avatax_settings' );

					if ( $option_name != 'action' && $value != $settings_array[ $option_name ] ) {
					    $settings_array[ $option_name ] = $value;
					    update_option( 'woocommerce_avatax_settings', $settings_array );
					}

				}

			}

			else

			{

				$r = $result->getMessages();

				$r = $r[0];		// lets worry about first message, usually thats all there is

				$msg = 'Validation error: <br/>Summary: '.$r->getSummary().'<br/>Details: '.$r->getDetails().

					'<br/>Please correct the address and try again.<br/>For more detail on this error, please refer to the TaxNOW log (under "Tools" in the Wordpress dashboard menu).';

				$response['Status'] ='0';

				$response['Message'] = $msg;

			}



			// --- It's AJAX query that expects JSON in response

			header( "Content-Type: text/x-json; charset: UTF-8" );

			header( "Cache-Control: no-store, no-cache, must-revalidate" );

			echo json_encode( $response );

			exit;

		}



        catch ( Exception $e )

        {

			$msg = '---catch---'.$e->getMessage();



			$response['Status'] ='0';

			$response['Message'] = $msg;



			// --- It's AJAX query that expects JSON in response

			header( "Content-Type: text/x-json; charset: UTF-8" );

			header( "Cache-Control: no-store, no-cache, must-revalidate" );

			echo json_encode( $response );

			exit;

		}

			

			

    } // ------- handle_post_validate_address_origin()



	// ============================================================

	public function product_write_taxnow_tab()

	{

		echo '<li class="taxnow_tab"><a href="#taxnow_product_data">TaxNOW</a></li>';

	}



	// ============================================================

	public function product_write_taxnow_panel()

	{

		echo '

		<div id="taxnow_product_data" class="panel woocommerce_options_panel">

		<div class="options_group">

';

		woocommerce_wp_text_input( array( 

				'id' => '_taxnow_taxcode', 'label' => '<abbr title="'. __('Avalara Tax Code', 'TN/Woo') .'">' . __('Avalara Tax Code', 'TN/Woo') . '</abbr>' ) );

		woocommerce_wp_text_input( array( 

				'id' => '_taxnow_freightcode', 'label' => '<abbr title="'. __('Avalara Freight Code', 'TN/Woo') .'">' . __('Avalara Freight Code', 'TN/Woo') . '</abbr>' ) );

		echo '

		<i>&nbsp;&nbsp;&nbsp;Note: These values will override the default TaxNOW settings.</i>

		<br/><br/>

		</div>

		</div>

';

	}



	// ============================================================

	public function process_product_meta_taxnow($post_id)

	{

		update_post_meta( $post_id, '_taxnow_taxcode', stripslashes( $_POST['_taxnow_taxcode'] ) );

		update_post_meta( $post_id, '_taxnow_freightcode', stripslashes( $_POST['_taxnow_freightcode'] ) );

	}



	// ============================================================

	function orderdetails_writepanel_taxamounts($post_id)

	{

		// display the tax information on the admin->order details page



		$data = get_post_meta( $post_id );



		// output takes from admin/post-types/writepanels/writepanel-order_data.php

		echo '

		<div class="clear"></div>

	</div>';		// end the area, then let post-hook end this one

?>

	<div class="totals_group">

		<h4><span class="tax_total_display inline_total"></span><?php _e( 'Tax Totals (from TaxNOW)', 'woocommerce' ); ?></h4>

		<ul class="totals">



			<li class="left">

				<label><?php _e( 'Sales Tax:', 'woocommerce' ); ?>&nbsp;<a class="tips" data-tip="<?php _e( 'Total tax for line items + fees', 'woocommerce' ); ?>" href="#">[?]</a></label>

				<input type="number" step="any" min="0" id="_order_tax" name="_order_tax" placeholder="0.00" value="<?php

					if ( isset( $data['_order_tax'][0] ) )

						echo esc_attr( $data['_order_tax'][0] );

				?>" class="calculated" />

			</li>



			<li class="right">

				<label><?php _e( 'Shipping Tax:', 'woocommerce' ); ?></label>

				<input type="number" step="any" min="0" id="_order_shipping_tax" name="_order_shipping_tax" placeholder="0.00" value="<?php

					if ( isset( $data['_order_shipping_tax'][0] ) )

						echo esc_attr( $data['_order_shipping_tax'][0] );

				?>" />

			</li>



		</ul>

<?php

	}

	

}



// initialize the class

$avatax_admin = new WC_Avalara_Admin();



?>